/*
 * @(#)Skewb.h
 *
 * Copyright 1994 - 2010  David A. Bagley, bagleyd@tux.org
 *
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Public header file for Skewb */

#ifndef _XtSkewb_h
#define _XtSkewb_h

/***********************************************************************
 *
 * Skewb Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNmono ((char *) "mono")
#define XtNframeColor ((char *) "frameColor")
#define XtNfaceColor0 ((char *) "faceColor0")
#define XtNfaceColor1 ((char *) "faceColor1")
#define XtNfaceColor2 ((char *) "faceColor2")
#define XtNfaceColor3 ((char *) "faceColor3")
#define XtNfaceColor4 ((char *) "faceColor4")
#define XtNfaceColor5 ((char *) "faceColor5")
#define XtNpieceBorder ((char *) "pieceBorder")
#define XtNdelay ((char *) "delay")
#define XtNsound ((char *) "sound")
#define XtNmoveSound ((char *) "moveSound")
#define XtNview ((char *) "view")
#define XtNorient ((char *) "orient")
#define XtNpractice ((char *) "practice")
#define XtNuserName ((char *) "userName")
#define XtNscoreFile ((char *) "scoreFile")
#define XtNscoreOnly ((char *) "scoreOnly")
#define XtNversionOnly ((char *) "versionOnly")
#define XtNmenu ((char *) "menu")
#define XtNstart ((char *) "start")
#define XtNcheat ((char *) "cheat")
#define XtNface ((char *) "face")
#define XtNpos ((char *) "position")
#define XtNdirection ((char *) "direction")
#define XtNcontrol ((char *) "control")
#define XtNfast ((char *) "fast")
#define XtNpixmapSize ((char *) "pixmapSize")
#define XtNselectCallback ((char *) "selectCallback")
#define XtCMono ((char *) "Mono")
#define XtCDelay ((char *) "Delay")
#define XtCSound ((char *) "Sound")
#define XtCMoveSound ((char *) "MoveSound")
#define XtCView ((char *) "View")
#define XtCOrient ((char *) "Orient")
#define XtCPractice ((char *) "Practice")
#define XtCUserName ((char *) "UserName")
#define XtCScoreFile ((char *) "ScoreFile")
#define XtCMenu ((char *) "Menu")
#define XtCFace ((char *) "Face")
#define XtCPos ((char *) "Position")
#define XtCDirection ((char *) "Direction")
#define XtCControl ((char *) "Control")
#define XtCFast ((char *) "Fast")
#define XtCPixmapSize ((char *) "PixmapSize")

typedef struct _SkewbClassRec *SkewbWidgetClass;

extern WidgetClass skewbWidgetClass;

typedef struct {
	XEvent     *event;
	int         reason;
	int         face, position, direction;
	int         control;
	int         fast;
} skewbCallbackStruct;
#endif

#define ACTION_READ 100
#define ACTION_WRITE 101
#define ACTION_EXIT 102
#define ACTION_HIDE 103
#define ACTION_PRACTICE_QUERY 104
#define ACTION_RANDOMIZE_QUERY 105
#define ACTION_RESTORE 106
#define ACTION_RESET 107
#define ACTION_AMBIGUOUS 108
#define ACTION_ILLEGAL 109
#define ACTION_MOVED 110
#define ACTION_CONTROL 111
#define ACTION_SOLVED 112
#define ACTION_COMPUTED 113
#define ACTION_UNDO 200
#define ACTION_REDO 201
#define ACTION_CLEAR 202
#define ACTION_PRACTICE 203
#define ACTION_RANDOMIZE 204
#define ACTION_SOLVE 205
#define ACTION_ORIENTIZE 206
#define ACTION_SPEED 207
#define ACTION_SLOW 208
#define ACTION_SOUND 209
#define ACTION_VIEW 210
#define ACTION_DIM 211
#define ACTION_CHEAT 212
#define ACTION_TR 300
#define ACTION_BR 301
#define ACTION_BL 302
#define ACTION_TL 303
#define ACTION_CW 305
#define ACTION_CCW 307
#define ACTION_TOP 308
#define ACTION_RIGHT 309
#define ACTION_BOTTOM 310
#define ACTION_LEFT 311
#define ACTION_CONTROL_TR 340
#define ACTION_CONTROL_BR 341
#define ACTION_CONTROL_BL 342
#define ACTION_CONTROL_TL 343
#define ACTION_CONTROL_CW 345
#define ACTION_CONTROL_CCW 347
#define ACTION_CONTROL_TOP 348
#define ACTION_CONTROL_RIGHT 349
#define ACTION_CONTROL_BOTTOM 350
#define ACTION_CONTROL_LEFT 351
#define ACTION_DESCRIPTION 900
#define ACTION_FEATURES 901
#define ACTION_REFERENCES 902
#define ACTION_ABOUT 903
#define ACTION_IGNORE 999

#define RESTORE_DIR (-5)
#define CLEAR_DIR (-4)
#define AMBIGUOUS_DIR (-3)
#define ILLEGAL_DIR (-2)
#define IGNORE_DIR (-1)
#define MAX_FACES 6
#define MAX_VIEWS 2
#define DEFAULT_ORIENT FALSE
#define DEFAULT_PRACTICE TRUE
#ifdef MONOTEST
#define DEFAULT_MONO TRUE
#else
#define DEFAULT_MONO FALSE
#endif
#define DEFAULT_REVERSE FALSE

#define BOOL_STRING(a) ((a==0)?"false":"true")

typedef struct _SkewbRec *SkewbWidget;

#endif /* _XtSkewb_h */
/* DON'T ADD STUFF AFTER THIS #endif */
