/* <<< Start of information >>>                                             */
/* This file is part of the xcolmix package.                                */
/* Copyright (C) 1996  Karel Kubat. All rights reserved.                    */
/*                                                                          */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/*                                                                          */
/* You may link this software with XForms (Copyright (C) by T.C. Zhao and   */
/* Mark Overmars) and distribute the resulting binary, under the            */
/* restrictions in clause 3 of the GPL, even though the resulting binary is */
/* not, as a whole, covered by the GPL. (You still need a separate license  */
/* to do so from the owner(s) of the copyright for XForms, however).  If a  */
/* derivative no longer requires XForms, you may use the unsupplemented GPL */
/* as its license by deleting this paragraph and therefore removing this    */
/* exemption for XForms.                                                    */
/*                                                                          */
/* This program is distributed in the hope that it will be useful,          */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/* GNU General Public License for more details.                             */
/*                                                                          */
/* You should have received a copy of the GNU General Public License        */
/* along with this program; if not, write to the Free Software              */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA */
/* <<< End of information >>>                                               */

#include "xcolmix.h"

typedef struct
{
    int r, g, b;
} RGB_;

static RGB_
    *rgb;
int
    nrgb;
    
static int rgb_lookup (int rr, int gg, int bb)
{
    int
        i;
        
    for (i = 0; i < nrgb; i++)
        if (rgb [i].r == rr && rgb [i].g == gg && rgb [i].b == bb)
            return (1);
            
    return (0);
}

static void rgb_insert (int rr, int gg, int bb)
{
    rgb = (RGB_ *) realloc (rgb, (nrgb + 1) * sizeof (RGB_));
    rgb [nrgb].r = rr;
    rgb [nrgb].g = gg;
    rgb [nrgb++].b = bb;
}

void load_lookup_browser ()
{
    FILE
        *f;
    char
        buf [128];
    int
        r, g, b;
        
    /* try to open file */
    if (! (f = fopen (rgbfile, "r")) )
    {
        fl_add_browser_line (lookup_browser, "Cannot read RGB data file!!");
        return;
    }
    
    while (1)
    {
        fgets (buf, 127, f);
        if (feof (f))
            break;
            
        if (sscanf (buf, "%d %d %d", &r, &g, &b) >= 3 &&
            ! rgb_lookup (r, g, b)
           )
        {
            fl_add_browser_line (lookup_browser, buf);
            rgb_insert (r, g, b);
        }
    }
    
    fclose (f);
}
