/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.MessageFactory;

public class BooleanConverter
implements Converter {
    public static final String CONVERTER_ID = "javax.faces.Boolean";
    public static final String BOOLEAN_ID = "javax.faces.converter.BooleanConverter.BOOLEAN";
    public static final String STRING_ID = "javax.faces.converter.STRING";

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() < 1) {
            return null;
        }
        try {
            return Boolean.valueOf(value);
        }
        catch (Exception e) {
            throw new ConverterException(MessageFactory.getMessage(context, BOOLEAN_ID, value, MessageFactory.getLabel(context, component)), (Throwable)e);
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return "";
        }
        try {
            return value.toString();
        }
        catch (Exception e) {
            throw new ConverterException(MessageFactory.getMessage(context, STRING_ID, value, MessageFactory.getLabel(context, component)), (Throwable)e);
        }
    }
}

