/*
 * Decompiled with CFR 0.152.
 */
package spec.jbb.validity;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import spec.jbb.validity.LoopBounds;
import spec.jbb.validity.PepTest;
import spec.jbb.validity.Sub;
import spec.jbb.validity.Super;

public class Check {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,Copyright (c) 1997-2005 Sun Microsystems, Inc.All rights reserved,Licensed Materials - Property of SPEC";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doCheck() {
        Object object;
        System.out.println("\nChecking JVM\n");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            object = new int[10];
            for (int i = 0; i <= 10; ++i) {
                object[i] = i;
            }
            System.out.println("Error: array bounds not checked");
            bl3 = true;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            bl = true;
        }
        finally {
            bl2 = true;
        }
        if (!bl) {
            System.out.println("1st bounds test error:\tindex exception not received");
            bl3 = true;
        }
        if (!bl2) {
            System.out.println("1st bounds test error:\tfinally clause not executed");
            bl3 = true;
        }
        if (bl && bl2) {
            System.out.println("1st bounds test:\tOK");
        }
        if (Check.checkSubclassing()) {
            bl3 = true;
        }
        if (Check.checkXMLErrorChecking()) {
            bl3 = true;
        }
        object = new LoopBounds();
        LoopBounds.run();
        if (LoopBounds.gotError) {
            System.out.println("2nd bounds test:\tfailed");
            bl3 = true;
        } else {
            System.out.println("2nd bounds test:\tOK");
        }
        PepTest pepTest = new PepTest();
        pepTest.instanceMain();
        if (pepTest.gotError) {
            bl3 = true;
        }
        if (bl3) {
            System.out.println("\nINVALID: JVM Check detected error(s)");
        } else {
            System.out.println("\nJVM Check OK");
        }
        return bl3;
    }

    private static boolean checkSubclassing() {
        boolean bl = false;
        Super super_ = new Super(3);
        Sub sub = new Sub(3);
        System.out.println(super_.getName() + ": " + super_.toString());
        System.out.println(sub.getName() + ": " + sub.toString());
        if (!super_.toString().equals("Class Super, public=34, protected=33, private=32")) {
            bl = true;
        }
        if (!sub.toString().equals("Class Super, public=804, protected=803, private=802")) {
            bl = true;
        }
        System.out.println("Super: prot=" + super_.getProtected() + ", priv=" + super_.getPrivate());
        System.out.println("Sub:  prot=" + sub.getProtected() + ", priv=" + sub.getPrivate());
        if (super_.getProtected() != 33 || super_.getPrivate() != 32) {
            bl = true;
        }
        if (sub.getProtected() != 111 || sub.getPrivate() != 105) {
            bl = true;
        }
        System.out.println("Subclass test " + (bl ? "error" : "OK"));
        return bl;
    }

    private static boolean checkXMLErrorChecking() {
        boolean bl = false;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            boolean bl2 = false;
            bl2 = document.getStrictErrorChecking();
            bl = !bl2;
            System.out.println("XML StrictErrorChecking test: " + (bl ? "error" : "OK"));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        return bl;
    }
}

