/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License version 3, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranties of MERCHANTABILITY,
 * SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef UPSTART_APPLICATION_CONTROLLER_H
#define UPSTART_APPLICATION_CONTROLLER_H

#include "../applicationcontroller.h"

namespace unitymir
{
namespace upstart
{

class ApplicationController : public unitymir::ApplicationController
{
public:
    ApplicationController();
    ~ApplicationController();

    pid_t primaryPidForAppId(const QString& appId);
    bool appIdHasProcessId(pid_t pid, const QString& appId);

    bool stopApplicationWithAppId(const QString& appId);
    bool startApplicationWithAppIdAndArgs(const QString& appId, const QStringList& arguments);

private:
    struct Private;
    QScopedPointer<Private> impl;
};

} // namespace upstart
} // namespace unitymir

#endif // UPSTART_APPLICATION_CONTROLLER_H
