/*
 *  Copyright (C) 2008 Nicolas Vion <nico@picapo.net>
 *
 *   This file is part of swac-get.
 *
 *   Swac-get is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   Swac-get is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with swac-get; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>
#include <unistd.h>
#include <dirent.h>
#include <string>
#include <cstring>
#include <list>
#include <iostream>

#include "posix.hh"

std::string get_home_dir() {
	passwd *infos = getpwuid(geteuid());
	std::string dir(infos->pw_dir);
	return dir + pathDelim;
}

bool list_subdirs(std::string path, std::list<std::string>* result) {
	DIR *dp;
	dirent *d;
	result->clear();

	if ((dp = opendir(path.c_str())) == NULL) {
		std::cerr << "Can not open directory" << std::endl; 
		return false;
	}
	
	while((d = readdir(dp)) != NULL)
		if(strcmp(d->d_name,".") && strcmp(d->d_name,".."))
			result->push_back(path + d->d_name + pathDelim);

	return true;
}

bool is_dir(std::string path) {
	struct stat stFileInfo;
	return (stat(path.c_str(), &stFileInfo) == 0) && S_ISDIR(stFileInfo.st_mode);
}

bool fileexists(std::string path) {
	struct stat stFileInfo;
	return (stat(path.c_str(), &stFileInfo) == 0) && S_ISREG(stFileInfo.st_mode);
}

bool mkdir(std::string path) {
	return (mkdir(path.c_str(), 0777) == 0);
}

bool file_remove(std::string path) {
	if (remove(path.c_str()) != 0) {
    		std::cerr << "Error deleting file" << std::endl;
		return false;
	}
	return true;
}
