---
title: Tools/Routes
permalink: /Tools/Routes/
---

The tools' names accord to their function.

# routecheck.py

Allows to verify whether routes within the given route-file(s) are valid
for the given network. Call(s):

```
routecheck.py <net> <vehicletypes> [-f|--fix] <routes>+
```

```
routecheck.py <net> <vehicletypes+routes>
```

If a route is broken (a diconnected), the tool writes something like the
following to cout:

If **--fix** (**-f**) is given, routes are tried to be repaired
(assuming only one link is missing). The name of the output file(s) is
generated by appending ".fixed". These file contain repaired routes (if
it was possible), each appended link is written in comments after the
vehicle.

## Known caveats

- The tool does not deal with vehicle types; it only checks whether
  routes are connected
- When working in **--fix**-mode a vehicle type file must be given
- No tests for dealing with networks that have internal edges

# analyzePersonPlans.py
Count the different types of person plans according to the sequence of used modes. Private rides are distinguished from public transport rides using the assumption that the name of the private vehicle will start with the name of the person (as happens for [DUAROUTER](../DUAROUTER.md)-generated person plans).
```
tools\route\analyzePersonPlans.py -r routes.xml
```
example output:
```
34: walk public walk
55: car walk
90: walk
```

# routes_Join.py

Joins routes belonging to two networks. A map file with the following
syntax is read first:

```
<EDGE_ID>-><EDGE_ID>
```

It describes at which edges the networks overlapped and which edge was
kept in the resulting one. Vehicles from both given route files starting
at the first of those edges will be at first not regarded, but their
routes are kept in memory. All other vehicles are kept, but if they pass
one of the mapped edges, the route is continued by choosing a random
route from the list of previously discarded ones which start at the
corresponding edge.

```
routes_Join.py <prefix#1> <routes#1> <prefix#2> <routes#2> <mapfile>
```

- <prefix\#1\>: The prefix to use for vehicles from the first routes
  file
- <routes\#1\>: The first routes file
- <prefix\#2\>: The prefix to use for vehicles from the second routes
  file
- <routes\#2\>: The second routes file
- <mapfile\>: The edge mapping

Attention\! The routes are not sorted in time\!

# sort_routes.py

This script sorts the vehicles in the given route file by their depart
time. If the option **--big** is supplied, a slow but memory efficent algorithm
is used.

```
<SUMO_HOME>/tools/route/sort_routes.py input.rou.xml -o output.rou.xml
```

# cutRoutes.py

This script cuts down routes from a large scenario to a sub-scenario.
This assumes the existence of a big scenario (*orig.net.xml* and
*orig.rou.xml*). The goal is to simulate only a smaller part of the
network (*reduced.net.xml*) keeping all of the routes that pass through
the reduced network. Output can be a route file or a trip file.
Depending on the given options the new departure times can be computed
from exitTimes (see [SUMO](../SUMO.md) option **--vehroute-output.exit-times**), extrapolated from
the original network or simply copied from the original departure times.
If the option **--big** is supplied, a slow but memory efficent algorithm is used
for sorting the output by departure time. Example usage

```
<SUMO_HOME>/tools/route/cutRoutes.py reduced.net.xml orig.rou.xml 
  --routes-output output.rou.xml --orig-net orig.net.xml
```

Filtering stopping places is also supported by setting the options **--additional-input** and **--stops-output**.

# routeStats.py

Compute a length-histogram for all routes in a given route file.
Alternatively, compute the difference in lengths for two route files
with the same vehicles. Routes must be child elements of `<vehicle>`-elements.
Output for plotting may also be generated (see **--help**).

```
<SUMO_HOME>/tools/route/routeStats.py myNet.net.xml myRoutes.rou.xml
```

When setting option **--attribute depart** a histogram on departure times (or departure time
differences) is generated instead.

# route2poly.py

Transform routes into polygons for visualization in
[SUMO-GUI](../SUMO-GUI.md). Using the options **--hue, --saturation, --brightness** the colors can be
controlled. Each of these options supports values from \[0, 1\] as well
as the special value *random*.

```
<SUMO_HOME>/tools/route/route2poly.py myNet.net.xml myRoutes.rou.xml
```

# route2sel.py

Transform routes into an edge selection file which contains all edges
used in any of the routes, trips or person plans. This file may be used
for visualization in [SUMO-GUI](../SUMO-GUI.md) or pruning a
network via [NETCONVERT](../NETCONVERT.md).

```
<SUMO_HOME>/tools/route2sel.py myRoutes.rou.xml -o usedEdges.txt
```

```
netconvert --net-file myNet.net.xml --keep-edges.input-file usedEdges.txt --output reduced.net.xml
```

# route_departOffset

Shifts the departure times of `<vehicle>`, `<trip>`, and `<flow>` elements by a specified amount.
When setting the option **--depart-edges Edge1,Edge2,...**, only vehicles that depart on one of the given
edges are affected.

```
<SUMO_HOME>/tools/route/route_departOffset.py --input-file myRoutes.rou.xml --output-file shifted.rou.xml --depart-offset 900
```

The option **--depart-interval a,b,c,d** shifts all departures within the interval \[a,b\[ to the
interval \[c,d\[.

```
<SUMO_HOME>/tools/route/route_departOffset.py --input-file myRoutes.rou.xml --output-file shifted.rou.xml --depart-interval 3600,7200,0,500
```

# showDepartsAndArrivalsPerEdge

Generates a visualization file for investigating traffic patterns in a
route file.

```
<SUMO_HOME>/tools/showDepartsAndArrivalsPerEdge.py myRoutes.rou.xml --output-file results.xml
```

The option **--intermediate** may be used to include the total number of passing vehicles
for each edge in the generated output.

The generated file *result.xml* can be loaded in [SUMO-GUI to color
edges by number of departs, arrivals or total number of passing
vehicles](../SUMO-GUI.md#visualizing_edge-related_data)

When investigating routes that pass a particular edge or intersection,
the input routes may be filtered using the option **--subpart** {{DT_STR}}:

```
<SUMO_HOME>/tools/showDepartsAndArrivalsPerEdge.py myRoutes.rou.xml --output-file results.xml --subpart edge3,edge4,edge5
```

This will only generate results for routes that contain the edge
sequence *edge3 edge4 edge5*.

# addStops2Routes.py

To declare a vehicle that stops in a parkingArea, a <stop\>-definition
must be part of the vehicle or it's route. This script adds stops to
routes.

```
<SUMO_HOME>/tools/addStops2Routes.py -r <route-file> -p <parking-areas> -d <duration in seconds> [-o <output-file>]
```

Stops in one or more parking areas (seperated by comma) are added to the
vehicles route, if they are part of the vehicles id. Example:

```
<routes>
    <vehicle id="0_parkingAreaA" depart="0">
      <route edges="e1 e2 e3"/>
    </vehicle>
</routes>
```

```
<SUMO_HOME>/tools/route/addStops2Routes.py -r <route-file> -p ParkingAreaA -d 3600 [-o <output-file>]
```

```
<routes>
    <vehicle id="0_parkingAreaA" depart="0">
      <route edges="e1 e2 e3"/>
      <stop parkingArea="parkingAreaA" duration="3600">
    </vehicle>
</routes>
```

Note, that the lane of that parking area must belong to one of the edges
"e1, e2, e3" of the vehicles route.

# tracemapper.py

This script maps a list of (geo) coordinates to a consecutive list of
edges in a given network (a route)

```
<SUMO_HOME>/tools/route/tracemapper.py -n <net-file> -t <trace-file> -o <route-output-file>
```

The input contains the coordinates for every vehicle in a single line.
Example:

```
vehicle1:363.66,497.79 2008.64,498.82
vehicle2:363.66,497.79 1498.46,989.78 2008.64,498.82
```

The output is a standard sumo route file

```
<routes>
    <route id="vehicle1" edges="beg rend"/>
    <route id="vehicle2" edges="beg left2end rend"/>
</routes>
```

The option --geo enables the conversion of the input coordinates with
the parameters given in the network. The mapping algorithm is also
available in the python library function sumolib.route.mapTrace.

# generateTurnRatios.py

This script is to calculate the turn ratios or turn movements from a
link to its downstream links with a given route file. The output file
can be directly used as input in jtrrouter, where the time interval will
be set for one day. The call is

```
<SUMO_HOME>/tools/generateTurnRatios.py -r <route-file>
```

The standard output is the traffic volumes. With the option -p turning
ratios will be calculated and outputted.

# tlsCycleAdaptation.py

This script is to adapt the cycle lengths of the signalized
intersections according to a given network and route file. The Webster's
equation is used to optimize the cycle length and the green times of the
traffic lights. Only one hour traffic volume is considered and PCE is
used instead of the number of vehicles when calculating traffic volumes.
The output will be saved in a xml-file and can be directly used as
additional file in SUMO. The call is

```
<SUMO_HOME>/tools/tlsCycleAdaptation.py -n <net-file> -r <route-file> -b <begin>
```

The signalization parameters, such as minimal green time, lost time,
yellow time, maximal and minimal cycles, can be adjusted with the use of
options. Option R is to restrict the maximal cycle length as the given
one, while Option u is to use the calculated max cycle length as the
cycle length for all intersections. With Option e only the green time
splits will be adapted.
