/***************************************************************

   The Subread software package is free software package:
   you can redistribute it and/or modify it under the terms
   of the GNU General Public License as published by the
   Free Software Foundation, either version 3 of the License,
   or (at your option) any later version.

   Subread is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

   See the GNU General Public License for more details.

   Authors: Drs Yang Liao and Wei Shi

  ***************************************************************/

#ifndef __LRMFILEIO_H_
#define __LRMFILEIO_H_

#define LRMGENE_INPUT_FASTQ 1
#define LRMGENE_INPUT_GZIP_FASTQ 51
#define LRMMAX_LINE_LENGTH (LRMMAX_READ_LENGTH + 10)

#include "LRMconfig.h"

int LRMhash_strcmp(const void * s1, const void * s2);
unsigned long LRMhash_strhash(const void * sv);

int LRMgenekey2int(char key []);

int LRMgeinput_open(const char * filename, LRMgene_input_t * input);

void LRMsambam_write_header(LRMcontext_t * context, LRMthread_context_t * thread_context);
void LRMbam_generate_tail_binary(LRMcontext_t * context, LRMthread_context_t * thread_context);

int LRMwrite_chunk_check_buffer_write(LRMcontext_t * context, LRMthread_context_t * thread_context, int force_write);
// return 0 if successful
int LRMfetch_next_read(LRMcontext_t * context, LRMthread_context_t * thread_context, unsigned int *read_len, char * read_name, char * read_text, char * qual_text, unsigned int * read_no_in_chunk);
// Return the length of this read or -1 if EOF.
int LRMgeinput_next_read(LRMgene_input_t * input, char * read_name, char * read_string, char * quality_string);
void LRMgeinput_close(LRMgene_input_t * input);

// returns read length
int LRMgeinput_readline(LRMgene_input_t * input, int buf_len, char * linebuffer) ;
void LRMreverse_read(char * ReadString, int Length);
void LRMreverse_quality(char * QualtyString, int Length);
int LRMload_offsets(LRMcontext_t * context);
int LRMlocate_gene_position(LRMcontext_t * context, unsigned int linear, char ** chro_name, int * pos);

void LRMpos2txt(LRMcontext_t * context, unsigned int linear, char * txt);
int LRMlocate_chro_length(LRMcontext_t * context, unsigned int linear, char ** chro_name, long long * chro_len);
int LRMwrite_chunk_add_buffered_output(LRMcontext_t * context, LRMthread_context_t * thread_context, LRMread_iteration_context_t * iteration_context, int flags,  char * chro_name, unsigned int chro_pos, int map_quality, char * cigar, int mis_matched, int multi_mapping_locations, int this_mapping_loca);
#endif
