/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_CMDDATA_H
#define _SC_CMDDATA_H

/**
 * a type that can be stored in the CmdRegistry
 */
class ScCmdData
{
public:
  virtual ~ScCmdData(){}
  virtual ScCmdData* clone() = 0;
};



template<typename T> class SimpleCmdData : public ScCmdData
{
public:
  SimpleCmdData( T t ) : _t(t)
  {
  }

  T get()
  {
    return _t;
  }

  ScCmdData* clone()
  {
    return new SimpleCmdData(_t);
  }

private:
  T _t;
};

typedef SimpleCmdData<long> IdCmdData;

#endif // _SC_CMDDATA_H
