/* ====================================================================
 * Copyright (c) 2006-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_ACTIONS_H
#define _SC_ACTIONS_H

enum Actions
{
  // working copy
  ActionWcDiffBase,
  ActionWcAdd,
  ActionWcRemove,
  ActionWcRevert,
  ActionWcCommit,
  ActionWcEditConflict,
  ActionWcResolved,
  ActionWcLog,
  ActionWcLogGraph,
  ActionWcProperties,
  ActionWcIgnore,
  ActionWcBlame,
  ActionWcLock,
  ActionWcUnlock,
  ActionWcCleanup,
  ActionWcMkdir,
  ActionWcExport,
  ActionWcUpdateRev,
  ActionWcBranchTag,
  ActionWcCat,

  // repository
  ActionRpLog,
  ActionRpLogGraph,
  ActionRpBlame,
  ActionRpBranchTag,
  ActionRpCheckout,
  ActionRpSwitch,
  ActionRpDiff,
  ActionRpMerge,
  ActionRpMkdir,
  ActionRpImport,
  ActionRpExport,
  ActionRpRemove,
  ActionRpCat,

  // bookmark working copy
  ActionBookmarkWcUpdate,
  ActionBookmarkWcUpdateRev,
  ActionBookmarkWcCommit,
  ActionBookmarkWcCurrent,

  // bookmark repository
  ActionBookmarkRpCheckout,
  ActionBookmarkRpSwitch,

  // bookmark working copy & repository
  ActionBookmarkLog,
  ActionBookmarkBranchTag,

  // bookmark project
  ActionBookmarkProjectRename,
  ActionBookmarkProjectRemove,
  ActionBookmarkProjectNew,
  ActionBookmarkProjectNewWizard,
  ActionBookmarkProjectNewRepository,
  ActionBookmarkProjectNewWorkingCopy,
  ActionBookmarkProjectEditTrunk,
  ActionBookmarkProjectEditBranches,
  ActionBookmarkProjectEditTags,

  // bookmark
  ActionBookmarkEdit,
  ActionBookmarkRemove,

  // bookmark options
  ActionBookmarkOptionRecursive,
  ActionBookmarkOptionUpdates,
  ActionBookmarkOptionAutoRefresh,

  // general
  ActionCmdAddIgnoreExist,
  ActionCmdReload,            // Reload Button
  ActionItemMenuNoBookmark,

  // administration
  ActionAdminMenuCreate
};

#endif //  _SC_ACTIONS_H
