use ui;
use core:geometry;
use graphics;
use layout;

/**
 * Various styles for slides that set up parts of the layout hierarchy in one step.
 */

// Create a simple title slide.
Grid title(Presentation p, Str title, Str subtitle) on Render {
	Grid g;

	g.add(FillBox(Size(10, p.size.h * 1 / 3)));
	g.nextLine();
	g.add(component(Heading(title, p.headingStyle)));
	g.nextLine();
	g.add(component(Heading(subtitle, p.contentStyle)));
	g.nextLine();

	g.expandCol(0);

	g;
}


// Create a slide with a caption and a single space for content.
CaptionLayout content(Presentation p, Str caption) on Render {
	CaptionLayout l;
	l.add(component(Heading(caption, p.headingStyle)));
	l.space = p.headingStyle.space;
	l;
}

// Create a slide with a caption and one or more columns with content.
ColumnLayout columns(Presentation p, Str caption) on Render {
	var root = content(p, caption);
	ColumnLayout c;
	c.bundleRoot = root;
	root.add(c);
	c;
}

// Create a slide with a caption and a grid layout.
Grid grid(Presentation p, Str caption) on Render {
	var root = content(p, caption);
	Grid g;
	g.bundleRoot = root;
	root.add(g);
	g;
}
