//
// Copyright (c) 2002--2010
// Toon Knapen, Karl Meerbergen, Kresimir Fresl,
// Thomas Klimpel and Rutger ter Borg
//
// Distributed under the Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)
//
// THIS FILE IS AUTOMATICALLY GENERATED
// PLEASE DO NOT EDIT!
//

#ifndef BOOST_NUMERIC_BINDINGS_LAPACK_COMPUTATIONAL_GBBRD_HPP
#define BOOST_NUMERIC_BINDINGS_LAPACK_COMPUTATIONAL_GBBRD_HPP

#include <boost/assert.hpp>
#include <boost/numeric/bindings/bandwidth.hpp>
#include <boost/numeric/bindings/begin.hpp>
#include <boost/numeric/bindings/detail/array.hpp>
#include <boost/numeric/bindings/is_column_major.hpp>
#include <boost/numeric/bindings/is_complex.hpp>
#include <boost/numeric/bindings/is_mutable.hpp>
#include <boost/numeric/bindings/is_real.hpp>
#include <boost/numeric/bindings/lapack/workspace.hpp>
#include <boost/numeric/bindings/remove_imaginary.hpp>
#include <boost/numeric/bindings/size.hpp>
#include <boost/numeric/bindings/stride.hpp>
#include <boost/numeric/bindings/value_type.hpp>
#include <boost/static_assert.hpp>
#include <boost/type_traits/is_same.hpp>
#include <boost/type_traits/remove_const.hpp>
#include <boost/utility/enable_if.hpp>

//
// The LAPACK-backend for gbbrd is the netlib-compatible backend.
//
#include <boost/numeric/bindings/lapack/detail/lapack.h>
#include <boost/numeric/bindings/lapack/detail/lapack_option.hpp>

namespace boost {
namespace numeric {
namespace bindings {
namespace lapack {

//
// The detail namespace contains value-type-overloaded functions that
// dispatch to the appropriate back-end LAPACK-routine.
//
namespace detail {

//
// Overloaded function for dispatching to
// * netlib-compatible LAPACK backend (the default), and
// * float value-type.
//
inline std::ptrdiff_t gbbrd( const char vect, const fortran_int_t m,
        const fortran_int_t n, const fortran_int_t ncc,
        const fortran_int_t kl, const fortran_int_t ku, float* ab,
        const fortran_int_t ldab, float* d, float* e, float* q,
        const fortran_int_t ldq, float* pt, const fortran_int_t ldpt,
        float* c, const fortran_int_t ldc, float* work ) {
    fortran_int_t info(0);
    LAPACK_SGBBRD( &vect, &m, &n, &ncc, &kl, &ku, ab, &ldab, d, e, q, &ldq,
            pt, &ldpt, c, &ldc, work, &info );
    return info;
}

//
// Overloaded function for dispatching to
// * netlib-compatible LAPACK backend (the default), and
// * double value-type.
//
inline std::ptrdiff_t gbbrd( const char vect, const fortran_int_t m,
        const fortran_int_t n, const fortran_int_t ncc,
        const fortran_int_t kl, const fortran_int_t ku, double* ab,
        const fortran_int_t ldab, double* d, double* e, double* q,
        const fortran_int_t ldq, double* pt, const fortran_int_t ldpt,
        double* c, const fortran_int_t ldc, double* work ) {
    fortran_int_t info(0);
    LAPACK_DGBBRD( &vect, &m, &n, &ncc, &kl, &ku, ab, &ldab, d, e, q, &ldq,
            pt, &ldpt, c, &ldc, work, &info );
    return info;
}

//
// Overloaded function for dispatching to
// * netlib-compatible LAPACK backend (the default), and
// * complex<float> value-type.
//
inline std::ptrdiff_t gbbrd( const char vect, const fortran_int_t m,
        const fortran_int_t n, const fortran_int_t ncc,
        const fortran_int_t kl, const fortran_int_t ku,
        std::complex<float>* ab, const fortran_int_t ldab, float* d, float* e,
        std::complex<float>* q, const fortran_int_t ldq,
        std::complex<float>* pt, const fortran_int_t ldpt,
        std::complex<float>* c, const fortran_int_t ldc,
        std::complex<float>* work, float* rwork ) {
    fortran_int_t info(0);
    LAPACK_CGBBRD( &vect, &m, &n, &ncc, &kl, &ku, ab, &ldab, d, e, q, &ldq,
            pt, &ldpt, c, &ldc, work, rwork, &info );
    return info;
}

//
// Overloaded function for dispatching to
// * netlib-compatible LAPACK backend (the default), and
// * complex<double> value-type.
//
inline std::ptrdiff_t gbbrd( const char vect, const fortran_int_t m,
        const fortran_int_t n, const fortran_int_t ncc,
        const fortran_int_t kl, const fortran_int_t ku,
        std::complex<double>* ab, const fortran_int_t ldab, double* d,
        double* e, std::complex<double>* q, const fortran_int_t ldq,
        std::complex<double>* pt, const fortran_int_t ldpt,
        std::complex<double>* c, const fortran_int_t ldc,
        std::complex<double>* work, double* rwork ) {
    fortran_int_t info(0);
    LAPACK_ZGBBRD( &vect, &m, &n, &ncc, &kl, &ku, ab, &ldab, d, e, q, &ldq,
            pt, &ldpt, c, &ldc, work, rwork, &info );
    return info;
}

} // namespace detail

//
// Value-type based template class. Use this class if you need a type
// for dispatching to gbbrd.
//
template< typename Value, typename Enable = void >
struct gbbrd_impl {};

//
// This implementation is enabled if Value is a real type.
//
template< typename Value >
struct gbbrd_impl< Value, typename boost::enable_if< is_real< Value > >::type > {

    typedef Value value_type;
    typedef typename remove_imaginary< Value >::type real_type;

    //
    // Static member function for user-defined workspaces, that
    // * Deduces the required arguments for dispatching to LAPACK, and
    // * Asserts that most arguments make sense.
    //
    template< typename MatrixAB, typename VectorD, typename VectorE,
            typename MatrixQ, typename MatrixPT, typename MatrixC,
            typename WORK >
    static std::ptrdiff_t invoke( const char vect, MatrixAB& ab, VectorD& d,
            VectorE& e, MatrixQ& q, MatrixPT& pt, MatrixC& c,
            detail::workspace1< WORK > work ) {
        namespace bindings = ::boost::numeric::bindings;
        BOOST_STATIC_ASSERT( (bindings::is_column_major< MatrixAB >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_column_major< MatrixQ >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_column_major< MatrixPT >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_column_major< MatrixC >::value) );
        BOOST_STATIC_ASSERT( (boost::is_same< typename remove_const<
                typename bindings::value_type< MatrixAB >::type >::type,
                typename remove_const< typename bindings::value_type<
                VectorD >::type >::type >::value) );
        BOOST_STATIC_ASSERT( (boost::is_same< typename remove_const<
                typename bindings::value_type< MatrixAB >::type >::type,
                typename remove_const< typename bindings::value_type<
                VectorE >::type >::type >::value) );
        BOOST_STATIC_ASSERT( (boost::is_same< typename remove_const<
                typename bindings::value_type< MatrixAB >::type >::type,
                typename remove_const< typename bindings::value_type<
                MatrixQ >::type >::type >::value) );
        BOOST_STATIC_ASSERT( (boost::is_same< typename remove_const<
                typename bindings::value_type< MatrixAB >::type >::type,
                typename remove_const< typename bindings::value_type<
                MatrixPT >::type >::type >::value) );
        BOOST_STATIC_ASSERT( (boost::is_same< typename remove_const<
                typename bindings::value_type< MatrixAB >::type >::type,
                typename remove_const< typename bindings::value_type<
                MatrixC >::type >::type >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< MatrixAB >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< VectorD >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< VectorE >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< MatrixQ >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< MatrixPT >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< MatrixC >::value) );
        BOOST_ASSERT( bindings::bandwidth_lower(ab) >= 0 );
        BOOST_ASSERT( bindings::bandwidth_upper(ab) >= 0 );
        BOOST_ASSERT( bindings::size(d) >= std::min<
                std::ptrdiff_t >(bindings::size_row(ab),
                bindings::size_column(ab)) );
        BOOST_ASSERT( bindings::size(e) >= std::min<
                std::ptrdiff_t >(bindings::size_row(ab),
                bindings::size_column(ab))-1 );
        BOOST_ASSERT( bindings::size(work.select(real_type())) >=
                min_size_work( bindings::size_row(ab),
                bindings::size_column(ab) ));
        BOOST_ASSERT( bindings::size_column(ab) >= 0 );
        BOOST_ASSERT( bindings::size_column(c) >= 0 );
        BOOST_ASSERT( bindings::size_minor(ab) == 1 ||
                bindings::stride_minor(ab) == 1 );
        BOOST_ASSERT( bindings::size_minor(c) == 1 ||
                bindings::stride_minor(c) == 1 );
        BOOST_ASSERT( bindings::size_minor(pt) == 1 ||
                bindings::stride_minor(pt) == 1 );
        BOOST_ASSERT( bindings::size_minor(q) == 1 ||
                bindings::stride_minor(q) == 1 );
        BOOST_ASSERT( bindings::size_row(ab) >= 0 );
        BOOST_ASSERT( bindings::stride_major(ab) >=
                bindings::bandwidth_lower(ab)+bindings::bandwidth_upper(ab)+
                1 );
        BOOST_ASSERT( vect == 'N' || vect == 'Q' || vect == 'P' ||
                vect == 'B' );
        return detail::gbbrd( vect, bindings::size_row(ab),
                bindings::size_column(ab), bindings::size_column(c),
                bindings::bandwidth_lower(ab), bindings::bandwidth_upper(ab),
                bindings::begin_value(ab), bindings::stride_major(ab),
                bindings::begin_value(d), bindings::begin_value(e),
                bindings::begin_value(q), bindings::stride_major(q),
                bindings::begin_value(pt), bindings::stride_major(pt),
                bindings::begin_value(c), bindings::stride_major(c),
                bindings::begin_value(work.select(real_type())) );
    }

    //
    // Static member function that
    // * Figures out the minimal workspace requirements, and passes
    //   the results to the user-defined workspace overload of the 
    //   invoke static member function
    // * Enables the unblocked algorithm (BLAS level 2)
    //
    template< typename MatrixAB, typename VectorD, typename VectorE,
            typename MatrixQ, typename MatrixPT, typename MatrixC >
    static std::ptrdiff_t invoke( const char vect, MatrixAB& ab, VectorD& d,
            VectorE& e, MatrixQ& q, MatrixPT& pt, MatrixC& c,
            minimal_workspace ) {
        namespace bindings = ::boost::numeric::bindings;
        bindings::detail::array< real_type > tmp_work( min_size_work(
                bindings::size_row(ab), bindings::size_column(ab) ) );
        return invoke( vect, ab, d, e, q, pt, c, workspace( tmp_work ) );
    }

    //
    // Static member function that
    // * Figures out the optimal workspace requirements, and passes
    //   the results to the user-defined workspace overload of the 
    //   invoke static member
    // * Enables the blocked algorithm (BLAS level 3)
    //
    template< typename MatrixAB, typename VectorD, typename VectorE,
            typename MatrixQ, typename MatrixPT, typename MatrixC >
    static std::ptrdiff_t invoke( const char vect, MatrixAB& ab, VectorD& d,
            VectorE& e, MatrixQ& q, MatrixPT& pt, MatrixC& c,
            optimal_workspace ) {
        namespace bindings = ::boost::numeric::bindings;
        return invoke( vect, ab, d, e, q, pt, c, minimal_workspace() );
    }

    //
    // Static member function that returns the minimum size of
    // workspace-array work.
    //
    static std::ptrdiff_t min_size_work( const std::ptrdiff_t m,
            const std::ptrdiff_t n ) {
        return 2*std::max< std::ptrdiff_t >(m,n);
    }
};

//
// This implementation is enabled if Value is a complex type.
//
template< typename Value >
struct gbbrd_impl< Value, typename boost::enable_if< is_complex< Value > >::type > {

    typedef Value value_type;
    typedef typename remove_imaginary< Value >::type real_type;

    //
    // Static member function for user-defined workspaces, that
    // * Deduces the required arguments for dispatching to LAPACK, and
    // * Asserts that most arguments make sense.
    //
    template< typename MatrixAB, typename VectorD, typename VectorE,
            typename MatrixQ, typename MatrixPT, typename MatrixC,
            typename WORK, typename RWORK >
    static std::ptrdiff_t invoke( const char vect, MatrixAB& ab, VectorD& d,
            VectorE& e, MatrixQ& q, MatrixPT& pt, MatrixC& c,
            detail::workspace2< WORK, RWORK > work ) {
        namespace bindings = ::boost::numeric::bindings;
        BOOST_STATIC_ASSERT( (bindings::is_column_major< MatrixAB >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_column_major< MatrixQ >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_column_major< MatrixPT >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_column_major< MatrixC >::value) );
        BOOST_STATIC_ASSERT( (boost::is_same< typename remove_const<
                typename bindings::value_type< VectorD >::type >::type,
                typename remove_const< typename bindings::value_type<
                VectorE >::type >::type >::value) );
        BOOST_STATIC_ASSERT( (boost::is_same< typename remove_const<
                typename bindings::value_type< MatrixAB >::type >::type,
                typename remove_const< typename bindings::value_type<
                MatrixQ >::type >::type >::value) );
        BOOST_STATIC_ASSERT( (boost::is_same< typename remove_const<
                typename bindings::value_type< MatrixAB >::type >::type,
                typename remove_const< typename bindings::value_type<
                MatrixPT >::type >::type >::value) );
        BOOST_STATIC_ASSERT( (boost::is_same< typename remove_const<
                typename bindings::value_type< MatrixAB >::type >::type,
                typename remove_const< typename bindings::value_type<
                MatrixC >::type >::type >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< MatrixAB >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< VectorD >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< VectorE >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< MatrixQ >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< MatrixPT >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< MatrixC >::value) );
        BOOST_ASSERT( bindings::bandwidth_lower(ab) >= 0 );
        BOOST_ASSERT( bindings::bandwidth_upper(ab) >= 0 );
        BOOST_ASSERT( bindings::size(d) >= std::min<
                std::ptrdiff_t >(bindings::size_row(ab),
                bindings::size_column(ab)) );
        BOOST_ASSERT( bindings::size(e) >= std::min<
                std::ptrdiff_t >(bindings::size_row(ab),
                bindings::size_column(ab))-1 );
        BOOST_ASSERT( bindings::size(work.select(real_type())) >=
                min_size_rwork( bindings::size_row(ab),
                bindings::size_column(ab) ));
        BOOST_ASSERT( bindings::size(work.select(value_type())) >=
                min_size_work( bindings::size_row(ab),
                bindings::size_column(ab) ));
        BOOST_ASSERT( bindings::size_column(ab) >= 0 );
        BOOST_ASSERT( bindings::size_column(c) >= 0 );
        BOOST_ASSERT( bindings::size_minor(ab) == 1 ||
                bindings::stride_minor(ab) == 1 );
        BOOST_ASSERT( bindings::size_minor(c) == 1 ||
                bindings::stride_minor(c) == 1 );
        BOOST_ASSERT( bindings::size_minor(pt) == 1 ||
                bindings::stride_minor(pt) == 1 );
        BOOST_ASSERT( bindings::size_minor(q) == 1 ||
                bindings::stride_minor(q) == 1 );
        BOOST_ASSERT( bindings::size_row(ab) >= 0 );
        BOOST_ASSERT( bindings::stride_major(ab) >=
                bindings::bandwidth_lower(ab)+bindings::bandwidth_upper(ab)+
                1 );
        BOOST_ASSERT( vect == 'N' || vect == 'Q' || vect == 'P' ||
                vect == 'B' );
        return detail::gbbrd( vect, bindings::size_row(ab),
                bindings::size_column(ab), bindings::size_column(c),
                bindings::bandwidth_lower(ab), bindings::bandwidth_upper(ab),
                bindings::begin_value(ab), bindings::stride_major(ab),
                bindings::begin_value(d), bindings::begin_value(e),
                bindings::begin_value(q), bindings::stride_major(q),
                bindings::begin_value(pt), bindings::stride_major(pt),
                bindings::begin_value(c), bindings::stride_major(c),
                bindings::begin_value(work.select(value_type())),
                bindings::begin_value(work.select(real_type())) );
    }

    //
    // Static member function that
    // * Figures out the minimal workspace requirements, and passes
    //   the results to the user-defined workspace overload of the 
    //   invoke static member function
    // * Enables the unblocked algorithm (BLAS level 2)
    //
    template< typename MatrixAB, typename VectorD, typename VectorE,
            typename MatrixQ, typename MatrixPT, typename MatrixC >
    static std::ptrdiff_t invoke( const char vect, MatrixAB& ab, VectorD& d,
            VectorE& e, MatrixQ& q, MatrixPT& pt, MatrixC& c,
            minimal_workspace ) {
        namespace bindings = ::boost::numeric::bindings;
        bindings::detail::array< value_type > tmp_work( min_size_work(
                bindings::size_row(ab), bindings::size_column(ab) ) );
        bindings::detail::array< real_type > tmp_rwork( min_size_rwork(
                bindings::size_row(ab), bindings::size_column(ab) ) );
        return invoke( vect, ab, d, e, q, pt, c, workspace( tmp_work,
                tmp_rwork ) );
    }

    //
    // Static member function that
    // * Figures out the optimal workspace requirements, and passes
    //   the results to the user-defined workspace overload of the 
    //   invoke static member
    // * Enables the blocked algorithm (BLAS level 3)
    //
    template< typename MatrixAB, typename VectorD, typename VectorE,
            typename MatrixQ, typename MatrixPT, typename MatrixC >
    static std::ptrdiff_t invoke( const char vect, MatrixAB& ab, VectorD& d,
            VectorE& e, MatrixQ& q, MatrixPT& pt, MatrixC& c,
            optimal_workspace ) {
        namespace bindings = ::boost::numeric::bindings;
        return invoke( vect, ab, d, e, q, pt, c, minimal_workspace() );
    }

    //
    // Static member function that returns the minimum size of
    // workspace-array work.
    //
    static std::ptrdiff_t min_size_work( const std::ptrdiff_t m,
            const std::ptrdiff_t n ) {
        return std::max< std::ptrdiff_t >(m,n);
    }

    //
    // Static member function that returns the minimum size of
    // workspace-array rwork.
    //
    static std::ptrdiff_t min_size_rwork( const std::ptrdiff_t m,
            const std::ptrdiff_t n ) {
        return std::max< std::ptrdiff_t >(m,n);
    }
};


//
// Functions for direct use. These functions are overloaded for temporaries,
// so that wrapped types can still be passed and used for write-access. In
// addition, if applicable, they are overloaded for user-defined workspaces.
// Calls to these functions are passed to the gbbrd_impl classes. In the 
// documentation, most overloads are collapsed to avoid a large number of
// prototypes which are very similar.
//

//
// Overloaded function for gbbrd. Its overload differs for
// * User-defined workspace
//
template< typename MatrixAB, typename VectorD, typename VectorE,
        typename MatrixQ, typename MatrixPT, typename MatrixC,
        typename Workspace >
inline typename boost::enable_if< detail::is_workspace< Workspace >,
        std::ptrdiff_t >::type
gbbrd( const char vect, MatrixAB& ab, VectorD& d, VectorE& e, MatrixQ& q,
        MatrixPT& pt, MatrixC& c, Workspace work ) {
    return gbbrd_impl< typename bindings::value_type<
            MatrixAB >::type >::invoke( vect, ab, d, e, q, pt, c, work );
}

//
// Overloaded function for gbbrd. Its overload differs for
// * Default workspace-type (optimal)
//
template< typename MatrixAB, typename VectorD, typename VectorE,
        typename MatrixQ, typename MatrixPT, typename MatrixC >
inline typename boost::disable_if< detail::is_workspace< MatrixC >,
        std::ptrdiff_t >::type
gbbrd( const char vect, MatrixAB& ab, VectorD& d, VectorE& e, MatrixQ& q,
        MatrixPT& pt, MatrixC& c ) {
    return gbbrd_impl< typename bindings::value_type<
            MatrixAB >::type >::invoke( vect, ab, d, e, q, pt, c,
            optimal_workspace() );
}

} // namespace lapack
} // namespace bindings
} // namespace numeric
} // namespace boost

#endif
