/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * aint32 with this program; if not, write to the Free Software
 *
 *
 * Based on the original sources
 *   Faery Tale II -- The Halls of the Dead
 *   (c) 1993-1996 The Wyrmkeep Entertainment Co.
 */

#ifndef SAGA2_UITEXT_H
#define SAGA2_UITEXT_H

namespace Saga2 {

#define FILE_DIALOG_NONAME  "Empty Slot"

#define SAVE_DIALOG_NAME    "Save Game"
#define SAVE_DIALOG_BUTTON1 "Cancel"
#define SAVE_DIALOG_BUTTON2 "Save"

#define LOAD_DIALOG_NAME    "Load Game"
#define LOAD_DIALOG_BUTTON1 "Cancel"
#define LOAD_DIALOG_BUTTON2 "Load"

#define OPTN_DIALOG_NAME    "Options"
#define OPTN_DIALOG_SLIDE1  "Sound Effects Volume"
#define OPTN_DIALOG_SLIDE2  "Speech Volume"
#define OPTN_DIALOG_SLIDE3  "Music Volume"
#define OPTN_DIALOG_CHECK1  "Auto-Aggression"
#define OPTN_DIALOG_CHECK2  "Auto-Wield Weapon"
#define OPTN_DIALOG_CHECK3  "Speech Text"
#define OPTN_DIALOG_CHECK4  "Night"
#define OPTN_DIALOG_BUTTON1 "Resume Play"
#define OPTN_DIALOG_BUTTON2 "Save"
#define OPTN_DIALOG_BUTTON3 "Load"
#define OPTN_DIALOG_BUTTON4 "Quit"
#define OPTN_DIALOG_BUTTON5 "Credits"
#define OPTN_DIALOG_BUTTON6 "New Game"

#define VFYX_DIALOG_NAME    "Faery Tale Adventure"
#define VFYX_DIALOG_CAPTION "Do you really want to quit?"
#define VFYX_DIALOG_BUTTON1 "_Quit"
#define VFYX_DIALOG_BUTTON2 "_Continue"

} // end of namespace Saga2

#endif
