// Precomputed values for Galois field multiplication
pub const GF: [[u8; 256]; 7] = [
    [
        0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70, 0x80, 0x90, 0xA0, 0xB0, 0xC0, 0xD0, 0xE0,
        0xF0, 0xC3, 0xD3, 0xE3, 0xF3, 0x83, 0x93, 0xA3, 0xB3, 0x43, 0x53, 0x63, 0x73, 0x03, 0x13,
        0x23, 0x33, 0x45, 0x55, 0x65, 0x75, 0x05, 0x15, 0x25, 0x35, 0xC5, 0xD5, 0xE5, 0xF5, 0x85,
        0x95, 0xA5, 0xB5, 0x86, 0x96, 0xA6, 0xB6, 0xC6, 0xD6, 0xE6, 0xF6, 0x06, 0x16, 0x26, 0x36,
        0x46, 0x56, 0x66, 0x76, 0x8A, 0x9A, 0xAA, 0xBA, 0xCA, 0xDA, 0xEA, 0xFA, 0x0A, 0x1A, 0x2A,
        0x3A, 0x4A, 0x5A, 0x6A, 0x7A, 0x49, 0x59, 0x69, 0x79, 0x09, 0x19, 0x29, 0x39, 0xC9, 0xD9,
        0xE9, 0xF9, 0x89, 0x99, 0xA9, 0xB9, 0xCF, 0xDF, 0xEF, 0xFF, 0x8F, 0x9F, 0xAF, 0xBF, 0x4F,
        0x5F, 0x6F, 0x7F, 0x0F, 0x1F, 0x2F, 0x3F, 0x0C, 0x1C, 0x2C, 0x3C, 0x4C, 0x5C, 0x6C, 0x7C,
        0x8C, 0x9C, 0xAC, 0xBC, 0xCC, 0xDC, 0xEC, 0xFC, 0xD7, 0xC7, 0xF7, 0xE7, 0x97, 0x87, 0xB7,
        0xA7, 0x57, 0x47, 0x77, 0x67, 0x17, 0x07, 0x37, 0x27, 0x14, 0x04, 0x34, 0x24, 0x54, 0x44,
        0x74, 0x64, 0x94, 0x84, 0xB4, 0xA4, 0xD4, 0xC4, 0xF4, 0xE4, 0x92, 0x82, 0xB2, 0xA2, 0xD2,
        0xC2, 0xF2, 0xE2, 0x12, 0x02, 0x32, 0x22, 0x52, 0x42, 0x72, 0x62, 0x51, 0x41, 0x71, 0x61,
        0x11, 0x01, 0x31, 0x21, 0xD1, 0xC1, 0xF1, 0xE1, 0x91, 0x81, 0xB1, 0xA1, 0x5D, 0x4D, 0x7D,
        0x6D, 0x1D, 0x0D, 0x3D, 0x2D, 0xDD, 0xCD, 0xFD, 0xED, 0x9D, 0x8D, 0xBD, 0xAD, 0x9E, 0x8E,
        0xBE, 0xAE, 0xDE, 0xCE, 0xFE, 0xEE, 0x1E, 0x0E, 0x3E, 0x2E, 0x5E, 0x4E, 0x7E, 0x6E, 0x18,
        0x08, 0x38, 0x28, 0x58, 0x48, 0x78, 0x68, 0x98, 0x88, 0xB8, 0xA8, 0xD8, 0xC8, 0xF8, 0xE8,
        0xDB, 0xCB, 0xFB, 0xEB, 0x9B, 0x8B, 0xBB, 0xAB, 0x5B, 0x4B, 0x7B, 0x6B, 0x1B, 0x0B, 0x3B,
        0x2B,
    ],
    [
        0x00, 0x20, 0x40, 0x60, 0x80, 0xA0, 0xC0, 0xE0, 0xC3, 0xE3, 0x83, 0xA3, 0x43, 0x63, 0x03,
        0x23, 0x45, 0x65, 0x05, 0x25, 0xC5, 0xE5, 0x85, 0xA5, 0x86, 0xA6, 0xC6, 0xE6, 0x06, 0x26,
        0x46, 0x66, 0x8A, 0xAA, 0xCA, 0xEA, 0x0A, 0x2A, 0x4A, 0x6A, 0x49, 0x69, 0x09, 0x29, 0xC9,
        0xE9, 0x89, 0xA9, 0xCF, 0xEF, 0x8F, 0xAF, 0x4F, 0x6F, 0x0F, 0x2F, 0x0C, 0x2C, 0x4C, 0x6C,
        0x8C, 0xAC, 0xCC, 0xEC, 0xD7, 0xF7, 0x97, 0xB7, 0x57, 0x77, 0x17, 0x37, 0x14, 0x34, 0x54,
        0x74, 0x94, 0xB4, 0xD4, 0xF4, 0x92, 0xB2, 0xD2, 0xF2, 0x12, 0x32, 0x52, 0x72, 0x51, 0x71,
        0x11, 0x31, 0xD1, 0xF1, 0x91, 0xB1, 0x5D, 0x7D, 0x1D, 0x3D, 0xDD, 0xFD, 0x9D, 0xBD, 0x9E,
        0xBE, 0xDE, 0xFE, 0x1E, 0x3E, 0x5E, 0x7E, 0x18, 0x38, 0x58, 0x78, 0x98, 0xB8, 0xD8, 0xF8,
        0xDB, 0xFB, 0x9B, 0xBB, 0x5B, 0x7B, 0x1B, 0x3B, 0x6D, 0x4D, 0x2D, 0x0D, 0xED, 0xCD, 0xAD,
        0x8D, 0xAE, 0x8E, 0xEE, 0xCE, 0x2E, 0x0E, 0x6E, 0x4E, 0x28, 0x08, 0x68, 0x48, 0xA8, 0x88,
        0xE8, 0xC8, 0xEB, 0xCB, 0xAB, 0x8B, 0x6B, 0x4B, 0x2B, 0x0B, 0xE7, 0xC7, 0xA7, 0x87, 0x67,
        0x47, 0x27, 0x07, 0x24, 0x04, 0x64, 0x44, 0xA4, 0x84, 0xE4, 0xC4, 0xA2, 0x82, 0xE2, 0xC2,
        0x22, 0x02, 0x62, 0x42, 0x61, 0x41, 0x21, 0x01, 0xE1, 0xC1, 0xA1, 0x81, 0xBA, 0x9A, 0xFA,
        0xDA, 0x3A, 0x1A, 0x7A, 0x5A, 0x79, 0x59, 0x39, 0x19, 0xF9, 0xD9, 0xB9, 0x99, 0xFF, 0xDF,
        0xBF, 0x9F, 0x7F, 0x5F, 0x3F, 0x1F, 0x3C, 0x1C, 0x7C, 0x5C, 0xBC, 0x9C, 0xFC, 0xDC, 0x30,
        0x10, 0x70, 0x50, 0xB0, 0x90, 0xF0, 0xD0, 0xF3, 0xD3, 0xB3, 0x93, 0x73, 0x53, 0x33, 0x13,
        0x75, 0x55, 0x35, 0x15, 0xF5, 0xD5, 0xB5, 0x95, 0xB6, 0x96, 0xF6, 0xD6, 0x36, 0x16, 0x76,
        0x56,
    ],
    [
        0x00, 0x85, 0xC9, 0x4C, 0x51, 0xD4, 0x98, 0x1D, 0xA2, 0x27, 0x6B, 0xEE, 0xF3, 0x76, 0x3A,
        0xBF, 0x87, 0x02, 0x4E, 0xCB, 0xD6, 0x53, 0x1F, 0x9A, 0x25, 0xA0, 0xEC, 0x69, 0x74, 0xF1,
        0xBD, 0x38, 0xCD, 0x48, 0x04, 0x81, 0x9C, 0x19, 0x55, 0xD0, 0x6F, 0xEA, 0xA6, 0x23, 0x3E,
        0xBB, 0xF7, 0x72, 0x4A, 0xCF, 0x83, 0x06, 0x1B, 0x9E, 0xD2, 0x57, 0xE8, 0x6D, 0x21, 0xA4,
        0xB9, 0x3C, 0x70, 0xF5, 0x59, 0xDC, 0x90, 0x15, 0x08, 0x8D, 0xC1, 0x44, 0xFB, 0x7E, 0x32,
        0xB7, 0xAA, 0x2F, 0x63, 0xE6, 0xDE, 0x5B, 0x17, 0x92, 0x8F, 0x0A, 0x46, 0xC3, 0x7C, 0xF9,
        0xB5, 0x30, 0x2D, 0xA8, 0xE4, 0x61, 0x94, 0x11, 0x5D, 0xD8, 0xC5, 0x40, 0x0C, 0x89, 0x36,
        0xB3, 0xFF, 0x7A, 0x67, 0xE2, 0xAE, 0x2B, 0x13, 0x96, 0xDA, 0x5F, 0x42, 0xC7, 0x8B, 0x0E,
        0xB1, 0x34, 0x78, 0xFD, 0xE0, 0x65, 0x29, 0xAC, 0xB2, 0x37, 0x7B, 0xFE, 0xE3, 0x66, 0x2A,
        0xAF, 0x10, 0x95, 0xD9, 0x5C, 0x41, 0xC4, 0x88, 0x0D, 0x35, 0xB0, 0xFC, 0x79, 0x64, 0xE1,
        0xAD, 0x28, 0x97, 0x12, 0x5E, 0xDB, 0xC6, 0x43, 0x0F, 0x8A, 0x7F, 0xFA, 0xB6, 0x33, 0x2E,
        0xAB, 0xE7, 0x62, 0xDD, 0x58, 0x14, 0x91, 0x8C, 0x09, 0x45, 0xC0, 0xF8, 0x7D, 0x31, 0xB4,
        0xA9, 0x2C, 0x60, 0xE5, 0x5A, 0xDF, 0x93, 0x16, 0x0B, 0x8E, 0xC2, 0x47, 0xEB, 0x6E, 0x22,
        0xA7, 0xBA, 0x3F, 0x73, 0xF6, 0x49, 0xCC, 0x80, 0x05, 0x18, 0x9D, 0xD1, 0x54, 0x6C, 0xE9,
        0xA5, 0x20, 0x3D, 0xB8, 0xF4, 0x71, 0xCE, 0x4B, 0x07, 0x82, 0x9F, 0x1A, 0x56, 0xD3, 0x26,
        0xA3, 0xEF, 0x6A, 0x77, 0xF2, 0xBE, 0x3B, 0x84, 0x01, 0x4D, 0xC8, 0xD5, 0x50, 0x1C, 0x99,
        0xA1, 0x24, 0x68, 0xED, 0xF0, 0x75, 0x39, 0xBC, 0x03, 0x86, 0xCA, 0x4F, 0x52, 0xD7, 0x9B,
        0x1E,
    ],
    [
        0x00, 0x94, 0xEB, 0x7F, 0x15, 0x81, 0xFE, 0x6A, 0x2A, 0xBE, 0xC1, 0x55, 0x3F, 0xAB, 0xD4,
        0x40, 0x54, 0xC0, 0xBF, 0x2B, 0x41, 0xD5, 0xAA, 0x3E, 0x7E, 0xEA, 0x95, 0x01, 0x6B, 0xFF,
        0x80, 0x14, 0xA8, 0x3C, 0x43, 0xD7, 0xBD, 0x29, 0x56, 0xC2, 0x82, 0x16, 0x69, 0xFD, 0x97,
        0x03, 0x7C, 0xE8, 0xFC, 0x68, 0x17, 0x83, 0xE9, 0x7D, 0x02, 0x96, 0xD6, 0x42, 0x3D, 0xA9,
        0xC3, 0x57, 0x28, 0xBC, 0x93, 0x07, 0x78, 0xEC, 0x86, 0x12, 0x6D, 0xF9, 0xB9, 0x2D, 0x52,
        0xC6, 0xAC, 0x38, 0x47, 0xD3, 0xC7, 0x53, 0x2C, 0xB8, 0xD2, 0x46, 0x39, 0xAD, 0xED, 0x79,
        0x06, 0x92, 0xF8, 0x6C, 0x13, 0x87, 0x3B, 0xAF, 0xD0, 0x44, 0x2E, 0xBA, 0xC5, 0x51, 0x11,
        0x85, 0xFA, 0x6E, 0x04, 0x90, 0xEF, 0x7B, 0x6F, 0xFB, 0x84, 0x10, 0x7A, 0xEE, 0x91, 0x05,
        0x45, 0xD1, 0xAE, 0x3A, 0x50, 0xC4, 0xBB, 0x2F, 0xE5, 0x71, 0x0E, 0x9A, 0xF0, 0x64, 0x1B,
        0x8F, 0xCF, 0x5B, 0x24, 0xB0, 0xDA, 0x4E, 0x31, 0xA5, 0xB1, 0x25, 0x5A, 0xCE, 0xA4, 0x30,
        0x4F, 0xDB, 0x9B, 0x0F, 0x70, 0xE4, 0x8E, 0x1A, 0x65, 0xF1, 0x4D, 0xD9, 0xA6, 0x32, 0x58,
        0xCC, 0xB3, 0x27, 0x67, 0xF3, 0x8C, 0x18, 0x72, 0xE6, 0x99, 0x0D, 0x19, 0x8D, 0xF2, 0x66,
        0x0C, 0x98, 0xE7, 0x73, 0x33, 0xA7, 0xD8, 0x4C, 0x26, 0xB2, 0xCD, 0x59, 0x76, 0xE2, 0x9D,
        0x09, 0x63, 0xF7, 0x88, 0x1C, 0x5C, 0xC8, 0xB7, 0x23, 0x49, 0xDD, 0xA2, 0x36, 0x22, 0xB6,
        0xC9, 0x5D, 0x37, 0xA3, 0xDC, 0x48, 0x08, 0x9C, 0xE3, 0x77, 0x1D, 0x89, 0xF6, 0x62, 0xDE,
        0x4A, 0x35, 0xA1, 0xCB, 0x5F, 0x20, 0xB4, 0xF4, 0x60, 0x1F, 0x8B, 0xE1, 0x75, 0x0A, 0x9E,
        0x8A, 0x1E, 0x61, 0xF5, 0x9F, 0x0B, 0x74, 0xE0, 0xA0, 0x34, 0x4B, 0xDF, 0xB5, 0x21, 0x5E,
        0xCA,
    ],
    [
        0x00, 0xC0, 0x43, 0x83, 0x86, 0x46, 0xC5, 0x05, 0xCF, 0x0F, 0x8C, 0x4C, 0x49, 0x89, 0x0A,
        0xCA, 0x5D, 0x9D, 0x1E, 0xDE, 0xDB, 0x1B, 0x98, 0x58, 0x92, 0x52, 0xD1, 0x11, 0x14, 0xD4,
        0x57, 0x97, 0xBA, 0x7A, 0xF9, 0x39, 0x3C, 0xFC, 0x7F, 0xBF, 0x75, 0xB5, 0x36, 0xF6, 0xF3,
        0x33, 0xB0, 0x70, 0xE7, 0x27, 0xA4, 0x64, 0x61, 0xA1, 0x22, 0xE2, 0x28, 0xE8, 0x6B, 0xAB,
        0xAE, 0x6E, 0xED, 0x2D, 0xB7, 0x77, 0xF4, 0x34, 0x31, 0xF1, 0x72, 0xB2, 0x78, 0xB8, 0x3B,
        0xFB, 0xFE, 0x3E, 0xBD, 0x7D, 0xEA, 0x2A, 0xA9, 0x69, 0x6C, 0xAC, 0x2F, 0xEF, 0x25, 0xE5,
        0x66, 0xA6, 0xA3, 0x63, 0xE0, 0x20, 0x0D, 0xCD, 0x4E, 0x8E, 0x8B, 0x4B, 0xC8, 0x08, 0xC2,
        0x02, 0x81, 0x41, 0x44, 0x84, 0x07, 0xC7, 0x50, 0x90, 0x13, 0xD3, 0xD6, 0x16, 0x95, 0x55,
        0x9F, 0x5F, 0xDC, 0x1C, 0x19, 0xD9, 0x5A, 0x9A, 0xAD, 0x6D, 0xEE, 0x2E, 0x2B, 0xEB, 0x68,
        0xA8, 0x62, 0xA2, 0x21, 0xE1, 0xE4, 0x24, 0xA7, 0x67, 0xF0, 0x30, 0xB3, 0x73, 0x76, 0xB6,
        0x35, 0xF5, 0x3F, 0xFF, 0x7C, 0xBC, 0xB9, 0x79, 0xFA, 0x3A, 0x17, 0xD7, 0x54, 0x94, 0x91,
        0x51, 0xD2, 0x12, 0xD8, 0x18, 0x9B, 0x5B, 0x5E, 0x9E, 0x1D, 0xDD, 0x4A, 0x8A, 0x09, 0xC9,
        0xCC, 0x0C, 0x8F, 0x4F, 0x85, 0x45, 0xC6, 0x06, 0x03, 0xC3, 0x40, 0x80, 0x1A, 0xDA, 0x59,
        0x99, 0x9C, 0x5C, 0xDF, 0x1F, 0xD5, 0x15, 0x96, 0x56, 0x53, 0x93, 0x10, 0xD0, 0x47, 0x87,
        0x04, 0xC4, 0xC1, 0x01, 0x82, 0x42, 0x88, 0x48, 0xCB, 0x0B, 0x0E, 0xCE, 0x4D, 0x8D, 0xA0,
        0x60, 0xE3, 0x23, 0x26, 0xE6, 0x65, 0xA5, 0x6F, 0xAF, 0x2C, 0xEC, 0xE9, 0x29, 0xAA, 0x6A,
        0xFD, 0x3D, 0xBE, 0x7E, 0x7B, 0xBB, 0x38, 0xF8, 0x32, 0xF2, 0x71, 0xB1, 0xB4, 0x74, 0xF7,
        0x37,
    ],
    [
        0x00, 0xC2, 0x47, 0x85, 0x8E, 0x4C, 0xC9, 0x0B, 0xDF, 0x1D, 0x98, 0x5A, 0x51, 0x93, 0x16,
        0xD4, 0x7D, 0xBF, 0x3A, 0xF8, 0xF3, 0x31, 0xB4, 0x76, 0xA2, 0x60, 0xE5, 0x27, 0x2C, 0xEE,
        0x6B, 0xA9, 0xFA, 0x38, 0xBD, 0x7F, 0x74, 0xB6, 0x33, 0xF1, 0x25, 0xE7, 0x62, 0xA0, 0xAB,
        0x69, 0xEC, 0x2E, 0x87, 0x45, 0xC0, 0x02, 0x09, 0xCB, 0x4E, 0x8C, 0x58, 0x9A, 0x1F, 0xDD,
        0xD6, 0x14, 0x91, 0x53, 0x37, 0xF5, 0x70, 0xB2, 0xB9, 0x7B, 0xFE, 0x3C, 0xE8, 0x2A, 0xAF,
        0x6D, 0x66, 0xA4, 0x21, 0xE3, 0x4A, 0x88, 0x0D, 0xCF, 0xC4, 0x06, 0x83, 0x41, 0x95, 0x57,
        0xD2, 0x10, 0x1B, 0xD9, 0x5C, 0x9E, 0xCD, 0x0F, 0x8A, 0x48, 0x43, 0x81, 0x04, 0xC6, 0x12,
        0xD0, 0x55, 0x97, 0x9C, 0x5E, 0xDB, 0x19, 0xB0, 0x72, 0xF7, 0x35, 0x3E, 0xFC, 0x79, 0xBB,
        0x6F, 0xAD, 0x28, 0xEA, 0xE1, 0x23, 0xA6, 0x64, 0x6E, 0xAC, 0x29, 0xEB, 0xE0, 0x22, 0xA7,
        0x65, 0xB1, 0x73, 0xF6, 0x34, 0x3F, 0xFD, 0x78, 0xBA, 0x13, 0xD1, 0x54, 0x96, 0x9D, 0x5F,
        0xDA, 0x18, 0xCC, 0x0E, 0x8B, 0x49, 0x42, 0x80, 0x05, 0xC7, 0x94, 0x56, 0xD3, 0x11, 0x1A,
        0xD8, 0x5D, 0x9F, 0x4B, 0x89, 0x0C, 0xCE, 0xC5, 0x07, 0x82, 0x40, 0xE9, 0x2B, 0xAE, 0x6C,
        0x67, 0xA5, 0x20, 0xE2, 0x36, 0xF4, 0x71, 0xB3, 0xB8, 0x7A, 0xFF, 0x3D, 0x59, 0x9B, 0x1E,
        0xDC, 0xD7, 0x15, 0x90, 0x52, 0x86, 0x44, 0xC1, 0x03, 0x08, 0xCA, 0x4F, 0x8D, 0x24, 0xE6,
        0x63, 0xA1, 0xAA, 0x68, 0xED, 0x2F, 0xFB, 0x39, 0xBC, 0x7E, 0x75, 0xB7, 0x32, 0xF0, 0xA3,
        0x61, 0xE4, 0x26, 0x2D, 0xEF, 0x6A, 0xA8, 0x7C, 0xBE, 0x3B, 0xF9, 0xF2, 0x30, 0xB5, 0x77,
        0xDE, 0x1C, 0x99, 0x5B, 0x50, 0x92, 0x17, 0xD5, 0x01, 0xC3, 0x46, 0x84, 0x8F, 0x4D, 0xC8,
        0x0A,
    ],
    [
        0x00, 0xFB, 0x35, 0xCE, 0x6A, 0x91, 0x5F, 0xA4, 0xD4, 0x2F, 0xE1, 0x1A, 0xBE, 0x45, 0x8B,
        0x70, 0x6B, 0x90, 0x5E, 0xA5, 0x01, 0xFA, 0x34, 0xCF, 0xBF, 0x44, 0x8A, 0x71, 0xD5, 0x2E,
        0xE0, 0x1B, 0xD6, 0x2D, 0xE3, 0x18, 0xBC, 0x47, 0x89, 0x72, 0x02, 0xF9, 0x37, 0xCC, 0x68,
        0x93, 0x5D, 0xA6, 0xBD, 0x46, 0x88, 0x73, 0xD7, 0x2C, 0xE2, 0x19, 0x69, 0x92, 0x5C, 0xA7,
        0x03, 0xF8, 0x36, 0xCD, 0x6F, 0x94, 0x5A, 0xA1, 0x05, 0xFE, 0x30, 0xCB, 0xBB, 0x40, 0x8E,
        0x75, 0xD1, 0x2A, 0xE4, 0x1F, 0x04, 0xFF, 0x31, 0xCA, 0x6E, 0x95, 0x5B, 0xA0, 0xD0, 0x2B,
        0xE5, 0x1E, 0xBA, 0x41, 0x8F, 0x74, 0xB9, 0x42, 0x8C, 0x77, 0xD3, 0x28, 0xE6, 0x1D, 0x6D,
        0x96, 0x58, 0xA3, 0x07, 0xFC, 0x32, 0xC9, 0xD2, 0x29, 0xE7, 0x1C, 0xB8, 0x43, 0x8D, 0x76,
        0x06, 0xFD, 0x33, 0xC8, 0x6C, 0x97, 0x59, 0xA2, 0xDE, 0x25, 0xEB, 0x10, 0xB4, 0x4F, 0x81,
        0x7A, 0x0A, 0xF1, 0x3F, 0xC4, 0x60, 0x9B, 0x55, 0xAE, 0xB5, 0x4E, 0x80, 0x7B, 0xDF, 0x24,
        0xEA, 0x11, 0x61, 0x9A, 0x54, 0xAF, 0x0B, 0xF0, 0x3E, 0xC5, 0x08, 0xF3, 0x3D, 0xC6, 0x62,
        0x99, 0x57, 0xAC, 0xDC, 0x27, 0xE9, 0x12, 0xB6, 0x4D, 0x83, 0x78, 0x63, 0x98, 0x56, 0xAD,
        0x09, 0xF2, 0x3C, 0xC7, 0xB7, 0x4C, 0x82, 0x79, 0xDD, 0x26, 0xE8, 0x13, 0xB1, 0x4A, 0x84,
        0x7F, 0xDB, 0x20, 0xEE, 0x15, 0x65, 0x9E, 0x50, 0xAB, 0x0F, 0xF4, 0x3A, 0xC1, 0xDA, 0x21,
        0xEF, 0x14, 0xB0, 0x4B, 0x85, 0x7E, 0x0E, 0xF5, 0x3B, 0xC0, 0x64, 0x9F, 0x51, 0xAA, 0x67,
        0x9C, 0x52, 0xA9, 0x0D, 0xF6, 0x38, 0xC3, 0xB3, 0x48, 0x86, 0x7D, 0xD9, 0x22, 0xEC, 0x17,
        0x0C, 0xF7, 0x39, 0xC2, 0x66, 0x9D, 0x53, 0xA8, 0xD8, 0x23, 0xED, 0x16, 0xB2, 0x49, 0x87,
        0x7C,
    ],
];
