#include "rheolef.h"
using namespace rheolef;
using namespace std;
int main(int argc, char**argv) {
  environment rheolef (argc, argv);
  geo omega (argv[1]);
  space Xh (omega, argv[2]);
  Float alpha   = (argc > 3) ? atof(argv[3]) : 1;
  Float sigma   = (argc > 4) ? atof(argv[4]) : 3;
  point u (1,0,0);
  trial phi (Xh); test psi (Xh);
  form ah = integrate (dot(u,grad_h(phi))*psi + sigma*phi*psi)
          + integrate ("boundary", max(0, -dot(u,normal()))*phi*psi)
          + integrate ("internal_sides", 
	 	- dot(u,normal())*jump(phi)*average(psi)
                + 0.5*alpha*abs(dot(u,normal()))*jump(phi)*jump(psi));
  field lh = integrate ("boundary", max(0, -dot(u,normal()))*psi);
  solver sah (ah.uu());
  field phi_h(Xh);
  phi_h.set_u() = sah.solve(lh.u());
  dout << catchmark("sigma") << sigma << endl
       << catchmark("phi")   << phi_h;
}
