\name{modwt.2d}
\alias{modwt.2d}
\alias{imodwt.2d}
\title{Two-Dimensional Maximal Overlap Discrete Wavelet Transform}
\description{
  Performs a separable two-dimensional maximal overlap discrete wavelet
  transform (MODWT) on a matrix of arbitrary dimensions.
}
\usage{modwt.2d(x, wf, J = 4, boundary = "periodic")
imodwt.2d(y)
}
\arguments{
  \item{x}{input matrix}
  \item{wf}{name of the wavelet filter to use in the decomposition}
  \item{J}{depth of the decomposition} 
  \item{boundary}{only \code{"periodic"} is currently implemented}
  \item{y}{an object of class \code{dwt.2d}}
}
\value{
  List structure containing the \eqn{3J+1} sub-matrices from the
  decomposition.
}
\details{
  See references.
}
\references{
  Liang, J. and T. W. Parks (1994)
  A two-dimensional translation invariant wavelet representation and its
  applications,
  \emph{Proceedings ICIP-94}, Vol. 1, 66-70.

  Liang, J. and T. W. Parks (1994)
  Image coding using translation invariant wavelet transforms with
  symmetric extensions,
  \emph{IEEE Transactions on Image Processing}, \bold{7}, No. 5, 762-769.
}
\seealso{
  \code{\link{dwt.2d}}, \code{\link{shift.2d}}.
}
\examples{
## Xbox image
data(xbox)
xbox.modwt <- modwt.2d(xbox, "haar", 2)
## Level 1 decomposition
par(mfrow=c(2,2), pty="s")
image(xbox.modwt$LH1, col=rainbow(128), axes=FALSE, main="LH1")
image(xbox.modwt$HH1, col=rainbow(128), axes=FALSE, main="HH1")
frame()
image(xbox.modwt$HL1, col=rainbow(128), axes=FALSE, main="HL1")
## Level 2 decomposition
par(mfrow=c(2,2), pty="s")
image(xbox.modwt$LH2, col=rainbow(128), axes=FALSE, main="LH2")
image(xbox.modwt$HH2, col=rainbow(128), axes=FALSE, main="HH2")
image(xbox.modwt$LL2, col=rainbow(128), axes=FALSE, main="LL2")
image(xbox.modwt$HL2, col=rainbow(128), axes=FALSE, main="HL2")
sum((xbox - imodwt.2d(xbox.modwt))^2)

data(dau)
par(mfrow=c(1,1), pty="s")
image(dau, col=rainbow(128), axes=FALSE, main="Ingrid Daubechies")
sum(dau^2)
dau.modwt <- modwt.2d(dau, "d4", 2)
## Level 1 decomposition
par(mfrow=c(2,2), pty="s")
image(dau.modwt$LH1, col=rainbow(128), axes=FALSE, main="LH1")
image(dau.modwt$HH1, col=rainbow(128), axes=FALSE, main="HH1")
frame()
image(dau.modwt$HL1, col=rainbow(128), axes=FALSE, main="HL1")
## Level 2 decomposition
par(mfrow=c(2,2), pty="s")
image(dau.modwt$LH2, col=rainbow(128), axes=FALSE, main="LH2")
image(dau.modwt$HH2, col=rainbow(128), axes=FALSE, main="HH2")
image(dau.modwt$LL2, col=rainbow(128), axes=FALSE, main="LL2")
image(dau.modwt$HL2, col=rainbow(128), axes=FALSE, main="HL2")
sum((dau - imodwt.2d(dau.modwt))^2)
}
\author{B. Whitcher}
\keyword{ts}
