% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sass.R
\name{sass_partial}
\alias{sass_partial}
\title{Compile rules against a Sass Bundle or Sass Layer object}
\usage{
sass_partial(
  rules,
  bundle,
  options = sass_options_get(),
  output = NULL,
  write_attachments = NA,
  cache = sass_cache_get(),
  cache_key_extra = NULL
)
}
\arguments{
\item{rules}{A set of sass rules, which will be used instead of the rules
from \code{layer}.}

\item{bundle}{A \code{\link[=sass_bundle]{sass_bundle()}} or \code{\link[=sass_layer]{sass_layer()}} object.}

\item{options}{Compiler \code{\link[=sass_options]{sass_options()}}.}

\item{output}{Specifies path to output file for compiled CSS. May be a
character string or \code{\link[=output_template]{output_template()}}}

\item{write_attachments}{If the input contains \code{\link[=sass_layer]{sass_layer()}} objects that
have file attachments, and \code{output} is not \code{NULL}, then copy the file
attachments to the directory of \code{output}. (Defaults to \code{NA}, which merely
emits a warning if file attachments are present, but does not write them to
disk; the side-effect of writing extra files is subtle and potentially
destructive, as files may be overwritten.)}

\item{cache}{This can be a directory to use for the cache, a \link{FileCache}
object created by \code{\link[=sass_file_cache]{sass_file_cache()}}, or \code{FALSE} or \code{NULL} for no caching.}

\item{cache_key_extra}{additional information to considering when computing
the cache key. This should include any information that could possibly
influence the resulting CSS that isn't already captured by \code{input}. For
example, if \code{input} contains something like \code{"@import sass_file.scss"} you
may want to include the \code{\link[=file.mtime]{file.mtime()}} of \code{sass_file.scss} (or, perhaps, a
\code{\link[=packageVersion]{packageVersion()}} if \code{sass_file.scss} is bundled with an R package).}
}
\description{
Replaces the rules for a \code{\link[=sass_layer]{sass_layer()}} object with new rules, and compile it.
This is useful when (for example) you want to compile a set of rules using
variables derived from a theme, but you do not want the resulting CSS for the
entire theme -- just the CSS for the specific rules passed in.
}
\examples{
theme <- sass_layer(
  defaults = sass_file(system.file("examples/variables.scss", package = "sass")),
  rules = sass_file(system.file("examples/rules.scss", package = "sass"))
)

# Compile the theme
sass(theme)

# Sometimes we want to use the variables from the theme to compile other sass
my_rules <- ".someclass { background-color: $bg; color: $fg; }"
sass_partial(my_rules, theme)

}
