% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance-package.R
\docType{package}
\name{performance-package}
\alias{performance-package}
\title{performance: An R Package for Assessment, Comparison and Testing of
Statistical Models}
\description{
A crucial aspect when building regression models is to evaluate the
quality of modelfit. It is important to investigate how well models fit
to the data and which fit indices to report. Functions to create
diagnostic plots or to compute fit measures do exist, however, mostly
spread over different packages. There is no unique and consistent
approach to assess the model quality for different kind of models.

The primary goal of the \strong{performance} package is to fill this gap and
to provide utilities for computing \strong{indices of model quality} and
\strong{goodness of fit}. These include measures like r-squared (R2), root
mean squared error (RMSE) or intraclass correlation coefficient (ICC),
but also functions to check (mixed) models for overdispersion,
zero-inflation, convergence or singularity.

References: Lüdecke et al. (2021) \doi{10.21105/joss.03139}
}
\details{
\code{performance-package}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://easystats.github.io/performance/}
  \item Report bugs at \url{https://github.com/easystats/performance/issues}
}

}
\author{
\strong{Maintainer}: Daniel Lüdecke \email{officialeasystats@gmail.com} (\href{https://orcid.org/0000-0002-8895-3206}{ORCID})

Authors:
\itemize{
  \item Dominique Makowski \email{dom.makowski@gmail.com} (\href{https://orcid.org/0000-0001-5375-9967}{ORCID}) [contributor]
  \item Mattan S. Ben-Shachar \email{matanshm@post.bgu.ac.il} (\href{https://orcid.org/0000-0002-4287-4801}{ORCID}) [contributor]
  \item Indrajeet Patil \email{patilindrajeet.science@gmail.com} (\href{https://orcid.org/0000-0003-1995-6531}{ORCID}) [contributor]
  \item Philip Waggoner \email{philip.waggoner@gmail.com} (\href{https://orcid.org/0000-0002-7825-7573}{ORCID}) [contributor]
  \item Brenton M. Wiernik \email{brenton@wiernik.org} (\href{https://orcid.org/0000-0001-9560-6336}{ORCID}) [contributor]
  \item Rémi Thériault \email{remi.theriault@mail.mcgill.ca} (\href{https://orcid.org/0000-0003-4315-6788}{ORCID}) [contributor]
}

Other contributors:
\itemize{
  \item Vincent Arel-Bundock \email{vincent.arel-bundock@umontreal.ca} (\href{https://orcid.org/0000-0003-2042-7063}{ORCID}) [contributor]
  \item Martin Jullum [reviewer]
  \item gjo11 [reviewer]
  \item Etienne Bacher \email{etienne.bacher@protonmail.com} (\href{https://orcid.org/0000-0002-9271-5075}{ORCID}) [contributor]
  \item Joseph Luchman (\href{https://orcid.org/0000-0002-8886-9717}{ORCID}) [contributor]
}

}
\keyword{internal}
