% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exclude_pars.R
\name{save_pars}
\alias{save_pars}
\title{Control Saving of Parameter Draws}
\usage{
save_pars(group = TRUE, latent = FALSE, all = FALSE, manual = NULL)
}
\arguments{
\item{group}{A flag to indicate if group-level coefficients for
each level of the grouping factors should be saved (default is
\code{TRUE}). Set to \code{FALSE} to save memory. Alternatively,
\code{group} may also be a character vector naming the grouping factors
for which to save draws of coefficients.}

\item{latent}{A flag to indicate if draws of latent variables obtained by
using \code{me} and \code{mi} terms should be saved (default is
\code{FALSE}). Saving these draws allows to better use methods such as
\code{posterior_predict} with the latent variables but leads to very large
\R objects even for models of moderate size and complexity. Alternatively,
\code{latent} may also be a character vector naming the latent variables
for which to save draws.}

\item{all}{A flag to indicate if draws of all variables defined in Stan's
\code{parameters} block should be saved (default is \code{FALSE}). Saving
these draws is required in order to apply the certain methods such as
\code{bridge_sampler} and \code{bayes_factor}.}

\item{manual}{A character vector naming Stan variable names which should be
saved. These names should match the variable names inside the Stan code
before renaming. This feature is meant for power users only and will rarely
be useful outside of very special cases.}
}
\value{
A list of class \code{"save_pars"}.
}
\description{
Control which (draws of) parameters should be saved in a \pkg{brms}
model. The output of this function is meant for usage in the
\code{save_pars} argument of \code{\link{brm}}.
}
\examples{
\dontrun{
# don't store group-level coefficients
fit <- brm(count ~ zAge + zBase * Trt + (1|patient),
           data = epilepsy, family = poisson(),
           save_pars = save_pars(group = FALSE))
variables(fit)
}

}
