const theCodes = // 00 iso, 01 fin, 10 ini, 11 mid
[
	["\\96\\", "\\96\\", "\\96\\", "\\96\\"], // Hamza
	["\\97\\", "\\98\\", "\\97\\", "\\98\\"], // Aleph Madda
	["\\99\\", "\\100\\", "\\99\\", "\\100\\"], // Aleph Hamza Above
	["\\101\\", "\\102\\", "\\101\\", "\\102\\"], // Waw Hamza
	["\\103\\", "\\104\\", "\\103\\", "\\104\\"], // Aleph Hamza Below
	["\\105\\", "\\108\\", "\\106\\", "\\107\\"], // Ya Hamza
	["\\109\\", "\\110\\", "\\109\\", "\\110\\"], // Aleph
	["\\111\\", "\\114\\", "\\112\\", "\\113\\"], // Ba
	["\\115\\", "\\116\\", "\\115\\", "\\116\\"], // Ta Marbuta
	["\\117\\", "\\120\\", "\\118\\", "\\119\\"], // Ta
	["\\121\\", "\\124\\", "\\122\\", "\\123\\"], // Tha
	["\\125\\", "\\129\\", "\\126\\", "\\128\\"], // Gim
	["\\130\\", "\\133\\", "\\131\\", "\\132\\"], // 7a
	["\\134\\", "\\137\\", "\\135\\", "\\136\\"], // Kha
	["\\138\\", "\\139\\", "\\138\\", "\\139\\"], // Dal
	["\\140\\", "\\141\\", "\\140\\", "\\141\\"], // Dhal
	["\\142\\", "\\143\\", "\\142\\", "\\143\\"], // Ra
	["\\144\\", "\\145\\", "\\144\\", "\\145\\"], // Zain
	["\\146\\", "\\149\\", "\\147\\", "\\148\\"], // Sin
	["\\150\\", "\\153\\", "\\151\\", "\\152\\"], // Shin
	["\\154\\", "\\157\\", "\\155\\", "\\156\\"], // 9ad
	["\\158\\", "\\161\\", "\\159\\", "\\160\\"], // 9'ad
	["\\162\\", "\\165\\", "\\163\\", "\\164\\"], // 6a
	["\\166\\", "\\169\\", "\\167\\", "\\168\\"], // 6'a
	["\\170\\", "\\173\\", "\\171\\", "\\172\\"], // 3ain
	["\\174\\", "\\177\\", "\\175\\", "\\176\\"], // 3'ain
	,,,,,,
	["\\178\\", "\\181\\", "\\179\\", "\\180\\"], // Fa
	["\\182\\", "\\185\\", "\\183\\", "\\184\\"], // Qaf
	["\\186\\", "\\189\\", "\\187\\", "\\188\\"], // Kaf
	["\\190\\", "\\193\\", "\\191\\", "\\192\\"], // Lam
	["\\202\\", "\\205\\", "\\203\\", "\\204\\"], // Mim
	["\\206\\", "\\209\\", "\\207\\", "\\208\\"], // Nun
	["\\210\\", "\\214\\", "\\211\\", "\\213\\"], // Ha
	["\\215\\", "\\216\\", "\\215\\", "\\216\\"], // Waw
	["\\217\\", "\\220\\", "\\217\\", "\\220\\"], // Aleph Maqsura
	["\\221\\", "\\222\\", "\\218\\", "\\219\\"], // Ya
	["\\32\\", "\\32\\", "\\32\\", "\\32\\"], // Space
	["\\36\\", "\\36\\", "\\36\\", "\\36\\"], // Kashida
	["\\68\\", "\\68\\", "\\68\\", "\\68\\"], // Fat7atan
	["\\70\\", "\\70\\", "\\70\\", "\\70\\"], // Dammatan
	["\\69\\", "\\69\\", "\\69\\", "\\69\\"], // Kasratan
	["\\64\\", "\\64\\", "\\64\\", "\\64\\"], // Fat7a
	["\\66\\", "\\66\\", "\\66\\", "\\66\\"], // Damma
	["\\65\\", "\\65\\", "\\65\\", "\\65\\"], // Kasra
	["\\75\\", "\\75\\", "\\75\\", "\\75\\"], // Shadda
	["\\67\\", "\\67\\", "\\67\\", "\\67\\"], // Sokun
	["\\33\\", "\\33\\", "\\33\\", "\\33\\"], // Arabic Comma
	["\\34\\", "\\34\\", "\\34\\", "\\34\\"], // Arabic Semicolon
	["\\35\\", "\\35\\", "\\35\\", "\\35\\"], // Arabic Question Mark
	["\\40\\", "\\40\\", "\\40\\", "\\40\\"], // Arabic Opening Parenthesis
	["\\41\\", "\\41\\", "\\41\\", "\\41\\"], // Arabic Closing Parenthesis
	["\\48\\",,,], // 0
	["\\49\\",,,], // 1
	["\\50\\",,,], // 2
	["\\51\\",,,], // 3
	["\\52\\",,,], // 4
	["\\53\\",,,], // 5
	["\\54\\",,,], // 6
	["\\55\\",,,], // 7
	["\\56\\",,,], // 8
	["\\57\\",,,] // 9
];

const isRtLigable =
[
	0, // Hamza
	1, // Aleph Madda
	1, // Aleph Hamza Above
	1, // Waw Hamza
	1, // Aleph Hamza Below
	1, // Ya Hamza
	1, // Aleph
	1, // Ba
	1, // Ta Marbuta
	1, // Ta
	1, // Tha
	1, // Gim
	1, // 7a
	1, // Kha
	1, // Dal
	1, // Dhal
	1, // Ra
	1, // Zain
	1, // Sin
	1, // Shin
	1, // 9ad
	1, // 9'ad
	1, // 6a
	1, // 6'a
	1, // 3ain
	1, // 3'ain
	,,,,,,
	1, // Fa
	1, // Qaf
	1, // Kaf
	1, // Lam
	1, // Mim
	1, // Nun
	1, // Ha
	1, // Waw
	1, // Aleph Maqsura
	1, // Ya
	0, // Space
	1, // Kashida
	0, 0, 0, 0, 0, 0, 0, 0, // All eight signs
	0, 0, 0, 0, 0, // Punctuation
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0 // All ten digits
];

const isLtLigable =
[
	0, // Hamza
	0, // Aleph Madda
	0, // Aleph Hamza Above
	0, // Waw Hamza
	0, // Aleph Hamza Below
	1, // Ya Hamza
	0, // Aleph
	1, // Ba
	0, // Ta Marbuta
	1, // Ta
	1, // Tha
	1, // Gim
	1, // 7a
	1, // Kha
	0, // Dal
	0, // Dhal
	0, // Ra
	0, // Zain
	1, // Sin
	1, // Shin
	1, // 9ad
	1, // 9'ad
	1, // 6a
	1, // 6'a
	1, // 3ain
	1, // 3'ain
	,,,,,,
	1, // Fa
	1, // Qaf
	1, // Kaf
	1, // Lam
	1, // Mim
	1, // Nun
	1, // Ha
	0, // Waw
	0, // Aleph Maqsura
	1, // Ya
	0, // Space
	1, // Kashida
	0, 0, 0, 0, 0, 0, 0, 0, // All eight signs
	0, 0, 0, 0, 0, // Punctuation
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0 // All ten digits
];

function charOrd(txt, pos)
{
	var thePos = txt.charCodeAt(pos);

	switch (thePos)
	{
		case 32: return 42; // Space
		break;
		case 1600: return 43; // Kashida
		break;
		case 33:
		case 1548: return 52; // Arabic Comma
		break;
		case 34:
		case 1563: return 53; // Arabic Semicolon
		break;
		case 35:
		case 1567: return 54; // Arabic Question Mark
		break;
		case 40: return 55; // Arabic Opening Parenthesis
		break;
		case 41: return 56; // Arabic Closing Parenthesis
		break;
	}
	if ( (thePos >= 1569) && ( thePos <= 1610 ) ) { return thePos - 1569; } // Alphabet
	if ( (thePos >= 1611) && ( thePos <= 1618 ) ) { return thePos - 1611 + 44; } // Signs
	if ( (thePos >= 48) && ( thePos <= 57 ) ) { return thePos - 48 + 57; } // Digits
}

function signsBefore(txt, pos)
{
	var i = -1;
	var signs = 0;
	var charType;

	do
	{
		charType = txt.charCodeAt(pos + i);
		if ( (charType >= 1611) && (charType <= 1618) ) {signs++; i--;}
	} while ( (charType > 1610) && ((pos + i) > 0) );
	return signs;
}

function signsAfter(txt, pos)
{
	var i = 1;
	var signs = 0;
	var charType;

	do
	{
		charType = txt.charCodeAt(pos + i);
		if ( (charType >= 1611) && (charType <= 1618) ) {signs++; i++;}
	} while ( (charType > 1610) && ((pos + i) < txt.length) );
	return signs;
}

function getCode(theIn)
{
	var theResult = "";
	var theChar;
	var charState;
	var accumDigits = "";

	theChar = charOrd(theIn, 0);
	if (theIn.length < 2)
		{ return theCodes[theChar][0]; }
	else
	{
		charState = isRtLigable[charOrd(theIn, 1+signsAfter(theIn,0))] << 1;
		if (theChar >= 57) {accumDigits = accumDigits + theCodes[theChar][charState];}
		else {theResult = theCodes[theChar][charState];}
	}

	for (var i=1; i < (theIn.length - 1); i++)
	{
		theChar = charOrd(theIn, i);
		charState = (isLtLigable[charOrd(theIn, i-1-signsBefore(theIn, i))]) + (isRtLigable[charOrd(theIn, i+1+signsAfter(theIn, i))] << 1);
		if (theChar >= 57) {accumDigits = accumDigits + theCodes[theChar][charState];}
		else {theResult = theCodes[theChar][charState] + accumDigits + theResult; accumDigits = "";}
	}

	theChar = charOrd(theIn, i);
	charState = isLtLigable[charOrd(theIn, i-1-signsBefore(theIn, i))];
	if (theChar >= 57)
		{
			accumDigits = accumDigits + theCodes[theChar][charState];
			theResult = accumDigits + theResult;
		}
	else {theResult = theCodes[theChar][charState] + accumDigits + theResult;}

	theResult = theResult.replace(/\\98\\\\191\\/g, "\\194\\") // Lam Aleph Madda iso
	theResult = theResult.replace(/\\98\\\\192\\/g, "\\195\\") // Lam Aleph Madda fin
	theResult = theResult.replace(/\\100\\\\191\\/g, "\\196\\") // Lam Aleph Hamza Above iso
	theResult = theResult.replace(/\\100\\\\192\\/g, "\\197\\") // Lam Aleph Hamza Above fin
	theResult = theResult.replace(/\\104\\\\191\\/g, "\\198\\") // Lam Aleph Hamza Below iso
	theResult = theResult.replace(/\\104\\\\192\\/g, "\\199\\") // Lam Aleph Hamza Below fin
	theResult = theResult.replace(/\\110\\\\191\\/g, "\\200\\") // Lam Aleph iso
	theResult = theResult.replace(/\\110\\\\192\\/g, "\\201\\") // Lam Aleph fin
	theResult = theResult.replace(/\\204\\\\191\\/g, "\\223\\") // Lam Mim ini
	theResult = theResult.replace(/\\214\\\\192\\\\191\\/g, "\\62\\") // Lam Lam Ha
	theResult = theResult.replace(/\\68\\\\75\\/g, "\\76\\") // Shadda Fat7atan
	theResult = theResult.replace(/\\70\\\\75\\/g, "\\78\\") // Shadda Dammatan
	theResult = theResult.replace(/\\69\\\\75\\/g, "\\77\\") // Shadda Kasratan
	theResult = theResult.replace(/\\64\\\\75\\/g, "\\72\\") // Shadda Fat7a
	theResult = theResult.replace(/\\66\\\\75\\/g, "\\74\\") // Shadda Damma
	theResult = theResult.replace(/\\65\\\\75\\/g, "\\73\\") // Shadda Kasra

	return theResult;
}

function getSyllables(theIn)
{
	var theResult = "";
	var itemList;

	theResult = getCode(theIn);
	itemList = theResult.split(/\\32\\/);
	theResult = "";
	for(var i=(itemList.length-1); i>0; i--)
	{
		theResult = theResult + itemList[i] + "-";
	}
	theResult = theResult + itemList[i];

	return theResult;
}
