###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_sun_virtualbox_dos_vuln_lin.nasl 5287 2009-11-23 21:20:33Z nov $
#
# Sun VirtualBox or xVM VirtualBox Denial Of Service Vulnerability (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901055);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"2.1");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-3940");
  script_bugtraq_id(37024);
  script_name("Sun VirtualBox or xVM VirtualBox Denial Of Service Vulnerability (Linux)");
  desc = "
  Overview: This host is installed with Sun VirtualBox or xVM VirtualBox and is
  prone to Denial Of Service vulnerability.

  Vulnerability Insight:
  The flaw is caused due to the unspecified vulnerability in Guest Additions,
  via unknown vectors.

  Impact:
  Successful exploitation will let attacker to exhaust the kernel memory of the
  guest operating system, leading to a Denial of Service against the guest
  operating system running in a virtual machine.

  Impact Level: Application.

  Affected Software/OS:
  Sun VirtualBox version 3.x before 3.0.10
  Sun xVM VirtualBox 1.6.x and 2.0.x before 2.0.12, 2.1.x, and 2.2.x

  Fix: Upgrade to Sun VirtualBox version 3.0.10 or Sun xVM VirtualBox 2.0.12
  http://www.virtualbox.org/wiki/Downloads

  References:
  http://secunia.com/advisories/37363/
  http://en.securitylab.ru/nvd/387766.php
  http://sunsolve.sun.com/search/document.do?assetkey=1-66-271149-1

  CVSS Score:
    CVSS Base Score     : 2.1 (AV:L/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 1.6
  Risk factor: None";

  script_description(desc);
  script_summary("Check for the version of Sun VirtualBox or Sun xVM VirtualBox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_sun_virtualbox_detect_lin.nasl");
  script_require_keys("Sun/VirtualBox/Lin/Ver");
  exit(0);
}


include("version_func.inc");

# Check for product Sun VirtuaBox or Sun xVM VirtuaBox
vmVer = get_kb_item("Sun/VirtualBox/Lin/Ver");
if(!vmVer){
  exit(0);
}

vmVer = eregmatch(pattern:"([0-9]\.[0-9]+\.[0-9]+)", string:vmVer);
if(!vmVer[1]){
  exit(0);
}

if(version_in_range(version:vmVer[1], test_version:"1.6.0", test_version2:"1.6.6")||
   version_in_range(version:vmVer[1], test_version:"2.0.0", test_version2:"2.0.11")||
   version_in_range(version:vmVer[1], test_version:"2.1.0", test_version2:"2.1.4")||
   version_in_range(version:vmVer[1], test_version:"2.2.0", test_version2:"2.2.4")||
   version_in_range(version:vmVer[1], test_version:"3.0.0", test_version2:"3.0.9")){
  security_warning(0);
}
