###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ruby_rails_xss_vuln_lin.nasl 6090 2009-12-08 19:05:55Z dec $
#
# Ruby on Rails 'strip_tags' Cross Site Scripting Vulnerability (Linux)
#
# Authors:
# Antu Sanadi<santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801078);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-4214");
  script_bugtraq_id(37142);
  script_name("Ruby on Rails 'strip_tags' Cross Site Scripting Vulnerability (Linux)");
  desc = "
  Overview: The host is running Ruby on Rails, which is prone to Cross Site
  Scripting Vulnerability.

  Vulnerability Insight:
  This issue is caused due to the error in 'strip_tagi()' function which is
  not properly escaping non-printable ascii characters.

  Impact:
  Successful exploitation will let the attacker to execute arbitrary script code
  in the browser of an unsuspecting user in the context of the affected site or
  steal cookie-based authentication credentials and launch other attacks.

  Impact Level: Application

  Affected Software/OS:
  Ruby on Rails version before 2.3.5

  Fix:
  Apply the security patches or upgrade to Ruby on Rails version 2.3.5
  http://github.com/rails/rails/
  http://rubyonrails.org/download

  *****
  NOTE: Ignore this warning, if above mentioned patch is manually applied.
  *****

  References:
  http://secunia.com/advisories/37446
  http://www.securitytracker.com/id?1023245
  http://www.vupen.com/english/advisories/2009/3352
  http://www.openwall.com/lists/oss-security/2009/11/27/2

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.5
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Ruby on Rails");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_ruby_rails_detect.nasl");
  script_require_keys("Ruby-Rails/Linux/Ver");
  exit(0);
}


include("version_func.inc");

railsPort = 3000;

if(!get_port_state(railsPort)){
  exit(0);
}

railsVer = get_kb_item("Ruby-Rails/Linux/Ver");

if(railsVer){
  if(version_is_less(version:railsVer, test_version:"2.3.5")){
    security_hole(railsPort);
  }
}
