###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_novell_iprint_actvx_ctrl_vuln.nasl 538 2008-11-26 19:33:18Z nov $
#
# Novell iPrint ActiveX control Stack-based BOF Vulnerability
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800070);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2008-5231");
  script_name("Novell iPrint ActiveX control Stack-based BOF Vulnerability");
  desc = "

  Overview: The host is installed with Novell iPrint, and is prone to stack
  based buffer overflow vulnerability.

  Vulnerability Insight:
  The issue is due to the improper handling of user requests sent to the
  ExecuteRequest method in ienipp.ocx file.

  Impact:
  Successful attack could lead to execution of arbitrary code via a long target
  frame option value, which crashes the browser and may allow code execution.

  Impact Level: Application

  Affected Software/OS:
  Novell iPrint Client version 5.06 and prior on Windows.

  Fix: No solution/patch is available as on 27th November, 2008. Information
  regarding this issue will updated once the solution details are available.
  For updates refer, http://download.novell.com/index.jsp

  References:
  http://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2008-5231

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Novel iPrint");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

iPrintVer = registry_get_sz(key:"SOFTWARE\Novell-iPrint",
                            item:"Current Version");
if(!iPrintVer){
  exit(0);
}

novVer = eregmatch(pattern:"v([0-9.]+)", string:iPrintVer);
if(novVer[1] != NULL)
{
  if(version_is_less_equal(version:novVer[1], test_version:"5.06")){
    security_hole(0);
  }
}
