###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for mantis FEDORA-2008-0856
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860843);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2008-0856");
  script_name( "Fedora Update for mantis FEDORA-2008-0856");
  desc = "

  Vulnerability Insight:
  Mantis is a web-based bugtracking system.
  It is written in the PHP scripting language and requires the MySQL
  database and a webserver. Mantis has been installed on Windows, MacOS,
  OS/2, and a variety of Unix operating systems. Any web browser should
  be able to function as a client.
  
  Documentation can be found in: /usr/share/doc/mantis-1.1.1
  
  When the package has finished installing, you will need to perform some
  additional configuration steps; these are described in:
  /usr/share/doc/mantis-1.1.1/README.Fedora


  Affected Software/OS:
  mantis on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-January/msg00734.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of mantis");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"mantis", rpm:"mantis~1.1.1~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mantis-config-httpd", rpm:"mantis-config-httpd~1.1.1~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mantis", rpm:"mantis~1.1.1~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}