###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_dotnetnuke_auth_bypass_vuln.nasl 4349 2009-09-02 19:06:24Z sep $
#
# DotNetNuke Identity Authentication Bypass Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800684);
  script_version("$Revision: 1.0$");
  script_tag(name:"cvss_base", value:"6.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2008-7100");
  script_bugtraq_id(31145);
  script_name("DotNetNuke Identity Authentication Bypass Vulnerability");
  desc = "
  Overview: The host is installed with DotNetNuke and is prone to Authentication
  Bypass vulnerability.

  Vulnerability Insight:
  The vulnerability is caused due improper validation of a user identity.

  Impact:
  Successful exploitation could allows remote attackers to bypass security
  restrictions via unknown vectors related to a 'unique id' and impersonate
  other users and possibly gain elevated pivileges.

  Impact Level: Application

  Affected Software/OS:
  DotNetNuke versions 4.4.1 to 4.8.4.

  Fix: Upgrade to DotNetNuke version 4.9.0 or latest
  For Updates Refer, http://www.dotnetnuke.com/

  References:
  http://xforce.iss.net/xforce/xfdb/45081
  http://www.dotnetnuke.com/News/SecurityPolicy/Securitybulletinno21/tabid/1174/Default.aspx

  CVSS Score:
    CVSS Base Score      : 6.5 (AV:N/AC:L/Au:SI/C:P/I:P/A:P)
    CVSS Temporal Score  : 4.8
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the vVersion of DotNetNuke");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH ");
  script_family("Web application abuses");
  script_dependencies("gb_dotnetnuke_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

dnnPort = get_http_port(default:80);
if(!dnnPort){
  exit(0);
}

dnnVer = get_kb_item("www/" + dnnPort + "/DotNetNuke");
if(!dnnVer){
  exit(0);
}

dnnVer = eregmatch(pattern:"^(.+) under (/.*)$", string:dnnVer);
if(dnnVer[1] != NULL)
{
  if(version_in_range(version:dnnVer[1], test_version:"4.4.1", test_version2:"4.8.4")){
    security_warning(dnnPort);
  }
}
