/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "IconInfo.h"
#include "Path.h"
//  04 50 53 25 42

IconInfo::IconInfo(const Request& r):
	info_(r)
{
	if(!info_) info_ = Request("USER_INTERFACE");
}

IconInfo::~IconInfo()
{
}

int IconInfo::x() const
{
	return info_("X");
}

int IconInfo::y() const
{
	return info_("Y");
}

void IconInfo::position(int x,int y)
{
	info_("X") = x;
	info_("Y") = y;
}

void IconInfo::save(const Path& s)
{
	info_.save(s);
	//cout << "Save into " << s.str() << endl;
	//info_.print();
}

bool IconInfo::fix(const string& kind)
{
	const char* p = info_("ICON_CLASS");
	if(kind != p)
	{
		info_("ICON_CLASS") = kind.c_str();
		return true;
	}
	return false;
}
