/*---------------------------------------------------------------------\
|                          ____ _   __ __ ___                          |
|                         |__  / \ / / . \ . \                         |
|                           / / \ V /|  _/  _/                         |
|                          / /__ | | | | | |                           |
|                         /_____||_| |_| |_|                           |
|                                                                      |
\---------------------------------------------------------------------*/
/** \file	zypp/base/Fd.cc
 *
*/
extern "C"
{
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
}

#include <iostream>

#include "zypp/base/Exception.h"
#include "zypp/base/Fd.h"

///////////////////////////////////////////////////////////////////
namespace zypp
{ /////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////
  namespace base
  { /////////////////////////////////////////////////////////////////

    ///////////////////////////////////////////////////////////////////
    //
    //	METHOD NAME : Fd::Fd
    //	METHOD TYPE : Ctor
    //
    Fd::Fd( const Pathname & file_r, int open_flags, mode_t mode )
    : m_fd( -1 )
    {
      m_fd = open( file_r.asString().c_str(), open_flags, mode );
      if ( m_fd == -1 )
        ZYPP_THROW_ERRNO_MSG( Exception, std::string("open ")+file_r.asString() );
    }

    ///////////////////////////////////////////////////////////////////
    //
    //	METHOD NAME : Fd::close
    //	METHOD TYPE : void
    //
    void Fd::close()
    {
      if ( m_fd != -1 )
        {
          ::close( m_fd );
          m_fd = -1;
        }
    }

    /////////////////////////////////////////////////////////////////
  } // namespace base
  ///////////////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////////////
} // namespace zypp
///////////////////////////////////////////////////////////////////
