#if !defined (__CONTEXT_HPP)
#define __CONTEXT_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if !defined(__COMMON_HPP)
#include <Context.hpp>
#endif


namespace corelinux
{

   DECLARE_CLASS( State );
   DECLARE_CLASS( Context );

   /**
   Context defines the interface to clients and maintains an
   instance of a State subclass.
   */

   class Context
   {
   public:

                           /// Default Constructor

                           Context( void );

                           /** Copy Constructor
                           @param Context const reference
                           */

                           Context( ContextCref );

                           /// Virtual Destructor  

      virtual              ~Context( void );

      //
      // Operator overloads
      //
               /**
               Assignment operator overload
               @param  Context const reference
               @return Context reference to self
               */
            
               ContextRef  operator=( ContextCref );

               /**
               Equality operator overload
               @param Context const reference
               @return true if equal, false otherwise
               */

               bool        operator==( ContextCref ) const;

      //
      // Mutators
      //

               /// Invoke a context request which is delegated to State

      virtual  void  request( void ) throw ( NullPointerException );

               /// Change the state of the context

      virtual  void  changeState( StatePtr );

   protected:

         //
         // Accessors
         //
               /// Retrieve the state instance

               StatePtr    getState( void ) const;

         //
         // Mutators
         //

               ///  Set the state instance

               void        setState( StatePtr );

   private:

               /// The State instance

               StatePtr    theState;

   };

}
          
#endif   // if !defined(__CONTEXT_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/05/17 03:43:30 $
   $Locker:  $
*/


