/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package javax.ejb;

/**
 * <P>The EJBMetaData interface allows a client to obtain the enterprise
 * Bean's meta-data information. </P>
 * 
 * <P>The meta-data is intended for development tools used for building
 * applications that use deployed enterprise Beans, and for clients using
 * a scripting language to access the enterprise Bean. </P>
 * 
 * <P>Note that the EJBMetaData is not a remote interface. The class that
 * implements this interface (this class is typically generated by container
 * tools) must be serializable, and must be a valid RMI/IDL value type. </P>
 */
public interface EJBMetaData {

  /**
   * Obtains the home interface of the enterprise Bean.
   *
   * @return The home interface of the enterprise Bean.
   */
  public EJBHome getEJBHome();

  /**
   * Obtains the Class object for the enterprise Bean's home interface.
   *
   * @return The class object for the enterprise Bean's home interface.
   */
  public Class getHomeInterfaceClass();

   /**
    * Obtains the Class object for the enterprise Bean's remote interface.
    *
    * @return The class object for the enterprise Bean's remote interface.
    */
   public Class getRemoteInterfaceClass();

  /**
   * Obtains the Class object for the enterprise Bean's primary key class.
   *
   * @return The class object for the enterprise Bean's primary key class.
   */
  public Class getPrimaryKeyClass();

  /**
   * Tests if the type of the enterprise Bean is "session".
   *
   * @return True if the type of the enterprise Bean is session bean.
   */
  public boolean isSession();

  /**
   * Tests if the type of the enterprise Bean is "stateless session".
   *
   * @return True if the type of the enterprise Bean is stateless session.
   */
  public boolean isStatelessSession();
}
