.\"                                      Hey, EMACS: -*- nroff -*-
.TH GENERIC "1" "June 2021" "IRAF 2.17" "IRAF commands"
.SH NAME
generic \- generic preprocessor for IRAF
.SH SYNOPSIS
.B generic
.RI [ options ] " files" ...
.SH DESCRIPTION
The generic preprocessor is used to translate generic source code
(code written to work for any datatype) into type dependent source
code, suitable for compilation and insertion into a library.  The
generic source is translated for each datatype, producing a type
dependent copy of the source code for each datatype.  There are two
primary modes of operation:
.TP
.B [1]
The generic source is embedded in a normal file, bracketed by
\fI$for\fR and \fI$endfor\fR directives.  There is one input file and
one somewhat larger output file, with the generic code in the input
file being replaced in the output file by several copies of the
enclosed source, one for each datatype.  This mode is most commonly
used for modules to be linked in their entirety into an applications
package.  The \fB-o\fP parameter is used to specify the output
filename.
.TP
.B [2]
The entire input file is generic.  There may be multiple input files,
and for each input file N output files are generated, one for each
datatype specified with the \fB-t\fP parameter.  The output filenames
are automatically generated by appending the type character to the
root filename of the input file.  This mode is most commonly used for
object libraries.
.PP
The generic preprocessor operates by token replacement (currently
using a UNIX \fILex\fR lexical analyzer).  The input stream is broken
up into a stream of tokens.  Each token is examined to see if it is in
the following list, and the indicated action is taken if the token is
matched.  The generic preprocessor directives have the form "$NAME",
where $ marks a \fBgeneric\fP directive, and where NAME is the name of
the directive.
.TP
.B PIXEL
Replaced by the current type name, e.g., "int", "real", etc.
.TP
.B XPIXEL
Replaced by the current type name in upper case, preceded by an X,
e.g., "XINT", "XREAL", etc.  This is used for generic C procedures
meant to be called from SPP or Fortran.
.TP
.B INDEF
Replaced by the numeric constant denoting indefinite for the current
datatype.
.TP
.B INDEF[SILRDX]
These strings are \fInot\fR replaced, since the "INDEF" in this case
is not generic.
.TP
.B SZ_PIXEL
Replaced by "SZ_INT", "SZ_REAL", etc.
.TP
.B TY_PIXEL
Replaced by "TY_INT", "TY_REAL", etc.
.TP
.B $PIXEL
Replaced by the string "PIXEL".  This is used in doubly generic
sources, where the first pass translates $PIXEL to PIXEL, and the
second to the actual type string.
.TP
.B $INDEF
Replaced by the string "INDEF".
.TP
.B $t
Replaced by one of the characters [ubcsilrdx].
.TP
.B $T
Replaced by one of the characters [UBCSILRDX].
.TP
.B $/.../
Replaced by the string "...", i.e., whatever is within the //
delimiters.  Used to disable generic preprocessing of arbitrary text.
.TP
.B [0-9]+("$f"|"$F")
Replaced by the corresponding real or double constant.  For example,
"1$f" translates as "1.0" for type real, but as "1.0D0" for type
double.
.TP
.B $if (expression)
The conditional preprocessing facility.  If the $IF tests false the
code which follows is skipped over, and is not copied to the output
file.  Control transfers to the matching $ELSE or $ENDIF.  The
following may be used in the boolean expression:

.nf
"datatype"      denotes the current type
ubcsilrdx       any subset of these characters 
                  denotes the corresponding datatype
sizeof()        the size of the specified type,
                  e.g., for comparisons
!= ==           the relational operators
 >  <  >= <=


Examples:

        $if (datatype != dx)
            (code to be compiled if type not d or x)

        $if (sizeof(i) <= sizeof(r))
            (code to be compiled if size int <= real)
.fi

$IF constructs may be nested.  The directive may appear anywhere on
a line.
.TP
.B $else
Marks the else clause of a $IF.
.TP
.B $endif
Marks the end of a $IF.  One is required for every $IF.
.TP
.B $for (types)
For each of the listed types, output a translated copy of the code
between the $FOR and the matching $ENDFOR.  Nesting is permitted.

.nf
Example:
        $for (silrd)
        (any amount of generic code)
        $endfor
.fi
.TP
.B $endfor
Marks the end of a $FOR statement.
.TP
.B $$
Replaced by a single $.
.TP
.B /*...*/
C comments are not preprocessed.
.TP
.B "..."
Quoted strings are not preprocessed.
.TP
.B #...(EOL)
SPP comments are not preprocessed.
.TP
.B %...(EOL)
SPP Fortran escapes are not preprocessed.

.SH OPTIONS
.TP
.B \-k
Allow the output files generated by \fBgeneric\fP to clobber any existing
files.
.TP
.B \-o ofile
The name of the output file.  If this option is selected, only a single
file can be processed.
.TP
.B \-p prefix
A prefix to be prepended to the output filenames.  This is useful when
the output files are to be placed in a different directory.
.TP
.B \-t types
The datatypes for which output is desired.  One output file will be generated
for each type specified, with \fBgeneric\fP automatically generating the
output filename by appending the type character to the root filename of
the input file.  The \fItypes\fR string is some subset of [ubscilrdx],
where the type characters are as follows:

.nf
u - C unsigned short
b - C byte (char)
c - SPP character
s - SPP short
i - SPP int
l - SPP long
r - SPP real
d - SPP double
x - SPP complex
.fi

This option cannot be used in combination with the \fB-o\fP option,
and should not be used when generic code is expanded inline, rather
than written into multiple output files.
.TP
.I files
The input file or files to be processed.  Generic input files should
have the extension ".gx" or ".gc", although this is not required.
Only a single input file can be given if the \fB-o\fP option is
specified.

.SH EXAMPLES
1. Translate the generic source "aadd.gx" to produce the six output
files "aadds.x", "aaddi.x", etc., in the subdirectory "ak", clobbering
any existing files therein.  The \fBgeneric\fP task is a bootstrap
utility written in C and is implemented as a CL foreign task, hence
the UNIX command syntax.

        cl> generic \-k \-p ak/ \-t silrdx aadd.gx

2. Perform an inline transformation ($FOR directive) of the source
file "imsum.gx", producing the single file "imsum.x" as output.

        cl> generic \-k \-o imsum.x imsum.gx
    
3. The following is a simple example of a typical generic source file.
For additional examples, see the ".gx" sources in the VOPS, IMIO,
IMAGES and other directories.

.nf
# ALIM -- Compute the limits (minimum and maximum values)
#         of a vector.
# (this is a copy of the file vops$alim.gx).

procedure alim$t (a, npix, minval, maxval)

PIXEL   a[ARB], minval, maxval, value
int     npix, i

begin
        minval = a[1]
        maxval = a[1]

        do i = 1, npix {
            value = a[i]
            $if (datatype == x)
                if (abs(value) < abs(minval))
                    minval = value
                else if (abs(value) > abs(maxval))
                    maxval = value
            $else
                if (value < minval)
                    minval = value
                else if (value > maxval)
                    maxval = value
            $endif
        }
end
.fi


.SH SEE ALSO
.BR xc (1),
.BR xyacc (1).

.SH AUTHOR
This manual page was taken from the IRAF generic.hlp help file.
