module Main where                                                                                                          
                                                                                                                           
import Audio.TagLib.TagLib
import Control.Monad                                                                                                       
import Data.Maybe                                                                                                          
import System                                                                                                              
                                                                                                                           
main = do                                                                                                                  
    args <- getArgs                                                                                                        
    mapM showFile args                                                                                                     
                                                                                                                           
showFile filename =                                                                                                   
    tagFileOpen filename >?>= showTagFile
                                                                                                                           
showTagFile :: TagFile -> IO ()                                                                                     
showTagFile tagFile = do                                                                                                   
    tagFileGetTag tagFile >?>= showTag
    tagFileGetAudioProperties tagFile >?>= showAudioProperties                      
                                                                                                                           
showTag :: Tag -> IO ()                                                                                             
showTag tag = do                                                                                                           
    artist <- tagGetArtist tag                                                                                            
    album <- tagGetAlbum tag                                                                                              
    title <- tagGetTitle tag                                                                                              
    comment <- tagGetComment tag                                                                                          
    year <- tagGetYear tag                                                                                                
    track <- tagGetTrack tag                                                                                              
    putStrLn $ artist ++ " " ++ album ++ " " ++ title ++ " " ++ show year ++ " " ++ show track
                                                                                                                           
showAudioProperties :: AudioProperties -> IO ()                                                                     
showAudioProperties props = do                                                                                             
    bitrate <- audioPropertiesGetBitRate props
    length <- audioPropertiesGetDuration props
    samplerate <- audioPropertiesGetSampleRate props
    channels <- audioPropertiesGetChannels props
    print (bitrate, length, channels, samplerate)                                                                          

(>?>=) :: Monad m => m (Maybe a) -> (a -> m ()) -> m ()
g >?>= f = g >>= (?>= f)

(?>=) :: Monad m => Maybe a -> (a -> m ()) -> m () 
m ?>= f = maybe (return ()) f m
