-- | Tom Johnson. \"Tiling in my Music\".
-- /The Experimental Music Yearbook/, 1, 2009.
module Music.Theory.Tiling.Johnson_2009 where

import Music.Theory.Tiling.Canon

-- | Tilework for Clarinet, p.3
--
-- >>> v_print 36 (rr_voices p3)
-- >
-- > *.*..*............*.*..*............
-- > .*.*..*............*.*..*...........
-- > ........*.*..*............*.*..*....
-- > ....*..*.*............*..*.*........
-- > ...........*..*.*............*..*.*.
-- > ............*..*.*............*..*.*
p3 :: [R]
p3 = [(18,[0,2,5],[1,1,1],[0,1,8])
     ,(18,[0,3,5],[1,1,1],[4,11,12])]

-- | Tilework for String Quartet, p.5
--
-- >>> mapM_ (v_print 24 . r_voices) p5
-- >
-- > ******......******......
-- > ......******......******
-- >
-- > *.****.*....*.****.*....
-- > ......*.****.*....*.****
-- >
-- > **.***..*...**.***..*...
-- > ......**.***..*...**.***
-- >
-- > *..***.**...*..***.**...
-- > ......*..***.**...*..***
p5 :: [R]
p5 = [(12,[0..5],[1,1],[0,6])
     ,(12,[0,2,3,4,5,7],[1,1],[0,6])
     ,(12,[0,1,3,4,5,8],[1,1],[0,6])
     ,(12,[0,3,4,5,7,8],[1,1],[0,6])]

-- | Extra Perfect (p.7)
--
-- >>> v_print_m_from 18 6 6 (r_voices p7)
-- >
-- > **.*..|......|......|......|......|......
-- > ......|.*.*..|.*....|......|......|......
-- > ......|......|......|......|.*..*.|....*.
-- > ......|......|...*..|.*....|...*..|......
-- > ......|......|....*.|...*..|......|.*....
-- > ......|*.....|*.....|......|*.....|......
-- > ....*.|......|......|*.....|......|...*..
-- > ......|......|......|....*.|......|*.....
p7 :: R
p7 = (36,[0,1,3],[1,2,3,4,5,6,7,8],[0,7,25,51,52,78,105,130])

-- | Tilework for Log Drums (2005), p.10
--
-- >>> v_print 18 (r_voices p10)
-- >
-- > *.*.*.............
-- > .*...*...*........
-- > ...*...*...*......
-- > ......*...*...*...
-- > ........*...*...*.
-- > .............*.*.*
p10 :: R
p10 = (18,[0,1,2],[2,4,4,4,4,2],[0,1,3,6,8,13])

-- | Self-Similar Melodies (1996), p.11
--
-- >>> v_print_m 20 5 (r_voices p11)
-- >
-- > *.....*.....*..*..*.|....*.....*.....*...|..*..*..*.....*.....|*.....*.....*..*..*.|....*.....*.....*...
-- > ....................|*.....*.....*..*..*.|....*.....*.....*...|..*..*..*.....*.....|*.....*.....*..*..*.
-- > ....................|....................|*.....*.....*..*..*.|....*.....*.....*...|..*..*..*.....*.....
p11 :: R
p11 = (30,[0,6,12,15,18,24,30,36,42,45,48,54],[1,1,1],[0,20,40])

-- Local Variables:
-- truncate-lines:t
-- End:
