# Yamaha YM2151

the sound chip powering several arcade boards, synthesizers and the Sharp X1/X68000. eight 4-op FM channels, with overpowered LFO and almost unused noise generator.

it also was present on several pinball machines and synthesizers of the era, and later surpassed by the YM2414 (OPZ) present in the world-famous TX81Z.

in most arcade boards the chip was used in combination with a PCM chip, like [SegaPCM](segapcm.md) or [OKI's line of ADPCM chips](msm6295.md).

## effects

- `10xx`: **set noise frequency of channel 8 operator 4.** `00` disables noise while `01` to `20` enables it.
- `11xx`: **set feedback of channel.**
- `12xx`: **set operator 1 level.**
- `13xx`: **set operator 2 level.**
- `14xx`: **set operator 3 level.**
- `15xx`: **set operator 4 level.**
- `16xy`: **set multiplier of operator.**
  - `x` is the operator (1-4).
  - `y` is the new MULT value..
- `17xx`: **set LFO speed.**
- `18xx`: **set LFO waveform.**
  - `00`: saw
  - `01`: square
  - `02`: triangle
  - `03`: noise
- `19xx`: **set attack of all operators.**
- `1Axx`: **set attack of operator 1.**
- `1Bxx`: **set attack of operator 2.**
- `1Cxx`: **set attack of operator 3.**
- `1Dxx`: **set attack of operator 4.**
- `1Exx`: **set LFO AM depth.**
- `1Fxx`: **set LFO PM depth.**
- `30xx`: **enable envelope hard reset.**
  - this works by inserting a quick release and tiny delay before a new note.
- `50xy`: **set AM of operator.**
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` determines whether AM is on.
- `51xy`: **set SL of operator.**
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` is the value.
- `52xy`: **set RR of operator.**
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` is the value.
- `53xy`: **set DT of operator.**
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` is the value:
    - `0`: +0
    - `1`: +1
    - `2`: +2
    - `3`: +3
    - `4`: -0
    - `5`: -3
    - `6`: -2
    - `7`: -1
- `54xy`: **set RS of operator.**
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` is the value.
- `55xy`: **set DT2 of operator.**
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` is the value.
- `56xx`: **set DR of all operators.**
- `57xx`: **set DR of operator 1.**
- `58xx`: **set DR of operator 2.**
- `59xx`: **set DR of operator 3.**
- `5Axx`: **set DR of operator 4.**
- `5Bxx`: **set D2R/SR of all operators.**
- `5Cxx`: **set D2R/SR of operator 1.**
- `5Dxx`: **set D2R/SR of operator 2.**
- `5Exx`: **set D2R/SR of operator 3.**
- `5Fxx`: **set D2R/SR of operator 4.**
- `60xy`: **set operator mask.**
  - enables or disables operators.
  - if `x` is `0`, `y` ranges from `0` to `F`. it is a bitfield, so `y` is the sum of the active operators' bits:
    - OP1 is +1, OP2 is +2, OP3 is +4, and OP4 is +8.
    - for example, having only OP2 and OP4 on would be 2 + 8 = 10, resulting in an `xy` value of `0A`.
  - if `x` is `1` to `4`, the effect targets that operator; `y` turns it off with a value of `0` and on with a value of `1`.
    - for example, the effect `6031` enables OP3.
- `61xx`: **set algorithm** (0 to 7).
- `62xx`: **set LFO FM depth** (0 to 7).
- `63xx`: **set LFO AM depth** (0 to 3).

## info

this chip uses the [FM (OPM)](../4-instrument/fm-opm.md) instrument editor.

## chip config

the following options are available in the Chip Manager window:

- **Broken pitch macro/slides**: due to an oversight, pitch slides were twice as fast in older versions of Furnace. this option exists for compatibility.
