// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __ConstSizeMemPool_h__
#define __ConstSizeMemPool_h__

#include "Puma/Chain.h"
#include <assert.h>
#include <stdlib.h>
#include <iostream>
using namespace std;

#ifdef PROFILE_MEM
# include "Puma/RatioCounter.h"
#endif

namespace Puma {


template <int N>
class ConstSizeMemPool {
  Chain  m_Trash;
#ifdef PROFILE_MEM
  RatioCounter m_Ratio;
#endif

public:
  ConstSizeMemPool ()
#ifdef PROFILE_MEM
    : m_Ratio (N) 
#endif
  {}
  ~ConstSizeMemPool () {
    clean();
  }

  // don't rely on external instances, use singletons
  static ConstSizeMemPool &inst() {
	  static ConstSizeMemPool i;
	  return i;
  }

  void *alloc ();
  void free (void *p);
   
  inline void clean () {
    Chain *c = m_Trash.unlink ();
    while (c) {
      ::free (c);
      c = m_Trash.unlink ();
    }
  }
};

template <int N>
void *ConstSizeMemPool<N>::alloc () {
#ifdef PROFILE_MEM
    m_Ratio.use++;
#endif
    void *res = m_Trash.unlink ();
    if (res == 0) {
      res = ::malloc (N);
    }
#ifdef PROFILE_MEM
    else m_Ratio.reuse++;
#endif
    return res;
  }
   
template <int N>
void ConstSizeMemPool<N>::free (void *p) {
  m_Trash.insert ((Chain*)p);
}

template<int N> inline void *malloc () 
 { return ConstSizeMemPool<N>::inst().alloc(); }
template<int N> inline void free (void *p) 
 { ConstSizeMemPool<N>::inst().free(p); }
template<int N> inline void clean () 
 { ConstSizeMemPool<N>::inst().clean(); }

} // namespace Puma

#endif /* __ConstSizeMemPool_h__ */
