/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.file.attribute;

import java.io.DataInputStream;
import java.io.IOException;
import net.sf.jiapi.file.ConstantPool;
import net.sf.jiapi.file.attribute.Attribute;

public class ExceptionsAttribute
extends Attribute {
    public static final String ATTRIBUTE_NAME = "Exceptions";

    public ExceptionsAttribute(ConstantPool constantPool, short nameIndex, int attributeLength, DataInputStream dis) throws IOException {
        super(nameIndex, attributeLength, dis);
    }

    public String[] getExceptionNames() {
        String[] eNames = null;
        try {
            DataInputStream dis = this.getDataInputStream();
            short number_of_exceptions = dis.readShort();
            eNames = new String[number_of_exceptions];
            for (int i = 0; i < eNames.length; ++i) {
                short exception_index = dis.readShort();
                eNames[i] = this.cp.getClassName(exception_index).replace('/', '.');
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception occured", e);
        }
        return eNames;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        String[] eNames = this.getExceptionNames();
        for (int i = 0; i < eNames.length; ++i) {
            sb.append(eNames[i] + " ");
        }
        return sb.toString();
    }
}

