/* Aseprite
 * Copyright (C) 2001-2013  David Capello
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "app/ui/skin/skin_property.h"

#include "ui/widget.h"

namespace app {
namespace skin {

const char* SkinProperty::Name = "SkinProperty";

SkinProperty::SkinProperty()
  : Property(Name)
{
  m_look = NormalLook;
  m_upperLeft = 0;
  m_upperRight = 0;
  m_lowerLeft = 0;
  m_lowerRight = 0;
}

SkinProperty::~SkinProperty()
{
}

SkinPropertyPtr get_skin_property(ui::Widget* widget)
{
  SkinPropertyPtr skinProp;

  skinProp = widget->getProperty(SkinProperty::Name);
  if (skinProp == NULL) {
    skinProp.reset(new SkinProperty);
    widget->setProperty(skinProp);
  }

  return skinProp;
}

} // namespace skin
} // namespace app
