#include "Header.h"
#include "Stats.h"

 long Stats[MAX_STATS];
 struct clock Clocks[MAX_CLOCKS];
 int Internal_flags[MAX_INTERNAL_FLAGS];

/*************
 *
 *   init_stats()
 *
 *************/

void init_stats()
{
    int i;

    init_clocks();
    for (i = 0; i < MAX_INTERNAL_FLAGS; i++)
	Internal_flags[i] = 0;
    for (i = 0; i < MAX_STATS; i++)
	Stats[i] = 0;
    Stats[INIT_WALL_SECONDS] = wall_seconds();
}  /* init_stats */

/*************
 *
 *    print_mem()
 *
 *************/

void print_mem(FILE *fp)
{
    fprintf(fp, "\n------------- memory usage ------------\n");

    fprintf(fp, "Memory dynamically allocated (tp_alloc): %d.\n", total_mem());

}  /* print_mem */

/*************
 *
 *   p_mem
 *
 *************/

void p_mem(void)
{
    print_mem(stdout);
}  /* p_mem */

/*************
 *
 *    print_stats(fp)
 *
 *************/

void print_stats(FILE *fp)
{
    fprintf(fp, "\n-------------- statistics -------------\n");
    
    fprintf(fp, "Input:\n");
    fprintf(fp, "    Clauses input               %7ld\n", Stats[INPUT_CLAUSES]);
    fprintf(fp, "    Literal occurrences input   %7ld\n", Stats[LIT_OCC_INPUT]);
    fprintf(fp, "    Greatest atom               %7ld\n", Stats[GREATEST_ATOM]);
    fprintf(fp, "Unit preprocess:\n");
    fprintf(fp, "    Preprocess unit assignments %7ld\n", Stats[PREPROCESS_UNIT_ASSIGNS]);
    fprintf(fp, "    Clauses after subsumption   %7ld\n", Stats[CLAUSES_AFTER_SUB]);
    fprintf(fp, "    Literal occ. after subsump. %7ld\n", Stats[LIT_OCC_AFTER_SUB]);
    fprintf(fp, "    Selectable clauses          %7ld\n", Stats[SELECTABLE_CLAUSES]);
    fprintf(fp, "Decide:\n");
    fprintf(fp, "    Splits                      %7ld\n", Stats[SPLITS]);
    fprintf(fp, "    Unit assignments            %7ld\n", Stats[UNIT_ASSIGNS]);
    fprintf(fp, "    Failed paths                %7ld\n", Stats[FAILED_PATHS]);
    fprintf(fp, "    Models found                %7ld\n", Stats[MODELS]);
    fprintf(fp, "Memory:\n");
    fprintf(fp, "    Memory malloced           %7ld K\n", Stats[MEM_MALLOCED] / 1024);
    fprintf(fp, "    Memory tp_alloced         %7ld K\n", total_mem());
}  /* print_stats */

/*************
 *
 *    p_stats()
 *
 *************/

void p_stats(void)
{
    print_stats(stdout);
}  /* p_stats */

/*************
 *
 *    print_times(fp)
 *
 *************/

void print_times(FILE *fp)
{
    long t, min, hr;

    fprintf(fp, "\n----------- times (seconds) ----------- %s\n", get_time());

    t = run_time();
    fprintf(fp, "user CPU time                %10.2f  ", t / 1000.);
    t = t / 1000; hr = t / 3600; t = t % 3600; min = t / 60; t = t % 60;
    fprintf(fp, " (%ld hr, %ld min, %ld sec)\n", hr, min, t); 

    t = system_time();
    fprintf(fp, "system CPU time              %10.2f  ", t/ 1000.);
    t = t / 1000; hr = t / 3600; t = t % 3600; min = t / 60; t = t % 60;
    fprintf(fp, " (%ld hr, %ld min, %ld sec)\n", hr, min, t); 

    t = wall_seconds() - Stats[INIT_WALL_SECONDS];
    fprintf(fp, "wall-clock time              %7ld     ", t);
    hr = t / 3600; t = t % 3600; min = t / 60; t = t % 60;
    fprintf(fp, " (%ld hr, %ld min, %ld sec)\n", hr, min, t); 

    fprintf(fp, "input time                   %10.2f\n", clock_val(INPUT_TIME) / 1000.);
    fprintf(fp, "preprocess units             %10.2f\n", clock_val(PREPROCESS_TIME) / 1000.);
    fprintf(fp, "decide time (incl. preprocess)%9.2f\n", clock_val(DECIDE_TIME) / 1000.);

}  /* print_times */

/*************
 *
 *    p_times()
 *
 *************/

void p_times(void)
{
    print_times(stdout);
}  /* p_times */

/*************
 *
 *    output_stats
 *
 *************/

void output_stats(FILE *fp)
{
    print_stats(fp);
    print_times(fp);
}  /* output_stats */

