#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Dracula: The Resurrection
# send your bug reports to contact@dotslashplay.it
###

script_version=20240516.1

PLAYIT_COMPATIBILITY_LEVEL='2.28'

GAME_ID='dracula-1-the-resurrection'
GAME_NAME='Dracula: The Resurrection'

ARCHIVE_BASE_0_NAME='setup_dracula_the_resurrection_2.1.0.5.exe'
ARCHIVE_BASE_0_MD5='4f3ac9ea7b645ec3bc0ec2c9de24be79'
ARCHIVE_BASE_0_EXTRACTOR='innoextract'
ARCHIVE_BASE_0_EXTRACTOR_OPTIONS='--gog'
ARCHIVE_BASE_0_PART1_NAME='setup_dracula_the_resurrection_2.1.0.5.bin'
ARCHIVE_BASE_0_PART1_MD5='284f93ed3799267604cc1f25a2329699'
ARCHIVE_BASE_0_PART1_TYPE='rar'
ARCHIVE_BASE_0_SIZE='1400000'
ARCHIVE_BASE_0_VERSION='1.0-gog2.1.0.5'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/dracula_trilogy'

CONTENT_PATH_DEFAULT='game'
CONTENT_GAME_BIN_FILES='
dracula.exe
*.dll'
CONTENT_GAME_DATA_FILES='
*.tst
*.vr
*.pcx
*.wav
*.lst
*.4xm
a18tst
compiler.dat
cursor1.gif
cursor2.gif
llload.bmp
nomouse.com
nomouse.pif
nomouse.sp
retour.gif
signal.gif
test.sav
dracula.ico'
CONTENT_DOC_DATA_FILES='
*.pdf'

USER_PERSISTENT_FILES='
Saved_?.bin'

WINE_VIRTUAL_DESKTOP='auto'
## Set Windows version to Windows 98, otherwise menu can not be opened in-game.
WINE_WINETRICKS_VERBS='win98'

APP_MAIN_EXE='dracula.exe'
APP_MAIN_ICON='dracula.ico'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	## Convert all file paths to lowercase.
	tolower .
)

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
