/* $Id$ */
#ifndef EXON_INCLUDED
#define EXON_INCLUDED
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "list.h"
#include "listpool.h"
#include "filestring.h"


#define T Exon_T
typedef struct T *T;
struct T {
  int exoni;
  char firstchar, lastchar;
};

extern T
Exon_new (char firstchar, int exoni, char lastchar);
extern List_T
Exon_list_copy (List_T old, Listpool_T listpool);
extern void
Exon_list_gc (List_T *exons);
extern void
Exon_list_print_fwd (Filestring_T fp, List_T exons);
extern void
Exon_list_print_rev (Filestring_T fp, List_T exons);

extern void
Exon_list_print_fwd_stdout (List_T exons);
extern void
Exon_list_print_rev_stdout (List_T exons);

#undef T
#endif

