/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_POP.C $
   $Locker: ska $	$Name:  $	$State: Exp $

ob(ject): cfg_pop
su(bsystem): cmdline
ty(pe): H
sy(nopsis): 
sh(ort description): Pop one item from the input stack
he(ader files): 
lo(ng description): Pops one item of the input stack and call any necessary
	function, e.g. the close function associated with that item. Unless
	the poped item was the last one, the current state is reconstructed
	from the now current item of the input stack.
pr(erequistes): 
va(lue): 0: input stack empty \item: poped
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_pop.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <stdio.h>
#endif
#include <portable.h>
#include <dynstr.h>
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_POP.C 1.8 2001/02/27 01:28:06 ska Exp ska $";
#endif


int cfg_pop(struct Cfg_Getopt *optstru)
{	struct Cfg_iStackGetopt *p;

	DBG_ENTER("cfg_pop", Suppl_cmdline)

	assert(optstru);

	if((p = C(_stk)) == 0)
		DBG_RETURN_I( 0)

	if(p->C_closeFct)
		(p->C_closeFct)(optstru);

	free(p->C_buf);
	chkHeap
	if((C(_stk) = p->C_nxt) != 0) {		/* there is a new state */
		switch(C(type) = p->C_type) {
		case CFG_OPT:	/* we need the current information about the option */
			C(ch) = p->C_ch;
			C(longname) = p->C_longname;
			C(arg) = p->C_arg;
			C(bool) = p->C_bool;
			C(_glbBool) = p->C_glbBool;
			break;
		/* case CFG_ARG:
			is contained within S(buf) and is automatically restored */
		/* case CFG_NONE:
			case CFG_EOF:
				these state don't have any information to be preserved */
		default:
			break;
		}
	}
	free(p);

	chkHeap
	DBG_RETURN_I( C(_stk) != 0)
}
