#ifndef __APT_CACHE_GENERATOR_ENTRY_H
#define __APT_CACHE_GENERATOR_ENTRY_H

#include <glib.h>

typedef struct _AptCacheGeneratorEntry AptCacheGeneratorEntry;

AptCacheGeneratorEntry *apt_cache_generator_entry_new (const gchar *name, const gchar *version);
void apt_cache_generator_entry_free (AptCacheGeneratorEntry *entry);

gchar *apt_cache_generator_entry_serialize (AptCacheGeneratorEntry *entry);

void apt_cache_generator_entry_add_webapp_include (AptCacheGeneratorEntry *entry, const gchar *include);
void apt_cache_generator_entry_set_webapp_name (AptCacheGeneratorEntry *entry, const gchar *name);
void apt_cache_generator_entry_set_webapp_domain (AptCacheGeneratorEntry *entry, const gchar *domain);

#endif
