/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.impl;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.reasoner.TriplePattern;
import org.apache.jena.reasoner.rulesys.BindingEnvironment;
import org.apache.jena.reasoner.rulesys.Node_RuleVariable;
import org.apache.jena.reasoner.rulesys.impl.LPInterpreter;

public class LPBindingEnvironment
implements BindingEnvironment {
    protected LPInterpreter interpreter;

    public LPBindingEnvironment(LPInterpreter interpeter) {
        this.interpreter = interpeter;
    }

    @Override
    public Node getGroundVersion(Node node) {
        return LPInterpreter.deref(node);
    }

    @Override
    public boolean bind(Node var, Node value) {
        Node dvar = var;
        if (dvar instanceof Node_RuleVariable) {
            dvar = ((Node_RuleVariable)dvar).deref();
        }
        if (dvar instanceof Node_RuleVariable) {
            this.interpreter.bind(dvar, value);
            return true;
        }
        return var.sameValueAs(value);
    }

    @Override
    public Triple instantiate(TriplePattern pattern) {
        Node o;
        Node p;
        Node s = this.getGroundVersion(pattern.getSubject());
        if (s.isVariable()) {
            s = NodeFactory.createBlankNode();
        }
        if ((p = this.getGroundVersion(pattern.getPredicate())).isVariable()) {
            p = NodeFactory.createBlankNode();
        }
        if ((o = this.getGroundVersion(pattern.getObject())).isVariable()) {
            o = NodeFactory.createBlankNode();
        }
        return new Triple(s, p, o);
    }
}

