/* Copyright (C) 2001, 2007 United States Government as represented by
   the Administrator of the National Aeronautics and Space Administration.
   All Rights Reserved.
*/
package gov.nasa.worldwind.servers.wms;

import java.util.Enumeration;

/**
 *
 * @author brownrigg
 * @version $Id: WMSGetCapabilitiesRequest.java 5011 2008-04-10 16:53:54Z rick $
 */
public class WMSGetCapabilitiesRequest extends WMSRequest {
    
    public WMSGetCapabilitiesRequest(WMSHttpServletRequest req) {
        super(req);
        Enumeration params = req.getParameterNames();
        boolean hasRequestParam = false;
        boolean hasServiceParam = false;
        isValid = true;
        
        while(params.hasMoreElements()) {
            String param = (String)params.nextElement();
            String value = req.getParameter(param);
            if (value == null) continue;            
            
            if (param.equalsIgnoreCase(REQUEST)) {
                if (value.equals(CAPABILITIES))
                    hasRequestParam = true;
                continue;
            }            
            if (param.equalsIgnoreCase(SERVICE)) {
                if (value.equals(WMSSERVICE))
                    hasServiceParam = true;
                continue;
            }            
            if (param.equalsIgnoreCase(VERSION)) {
                version = value;
                continue;
            }
            if (param.equalsIgnoreCase(FORMAT)) {
                format = value;
                continue;
            }
            if (param.equalsIgnoreCase(UPDATESEQ)) {
                updateSequence = value;
                continue;
            }
        }
        
        // do we have the "mandated" parameters?
        if (!hasRequestParam || !hasServiceParam) {
            isValid = true;
            errorMsg.append("lacking mandatory REQUEST or SERVICE parameters; ");
        }
    }
        
    public boolean isValid() {
        return isValid;
    }
    
    public String getParseReport() {
        return errorMsg.toString();
    }
    
    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("GetCapabilities: version("); str.append(version);
        str.append(") format("); str.append(format);
        str.append(") updateSeq("); str.append(updateSequence);
        str.append(")");
        return str.toString();
    }
    
    // gettors...
    public String getVersion() { return version; }    
    public String getFormat() { return format; }
    public String getUpdateSequence() { return updateSequence; }
    
    private boolean isValid;
    private StringBuffer errorMsg = new StringBuffer();
    private String version = null;
    private String format = null;
    private String updateSequence = null;    

    private static final String REQUEST = "REQUEST";
    private static final String SERVICE = "SERVICE";
    private static final String VERSION = "VERSION";
    private static final String FORMAT  = "FORMAT";
    private static final String UPDATESEQ = "UPDATESEQUENCE";    
}
