/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import java.io.File;
import org.eclipse.birt.data.engine.api.DataEngineThreadLocal;

public class TempDir {
    private static TempDir instance;
    private String path;

    private TempDir(String path) {
        this.path = path;
    }

    public static void createInstance(String path) {
        instance = new TempDir(path);
    }

    public static TempDir getInstance() {
        if (instance == null) {
            String tempDir = String.valueOf(System.getProperty("java.io.tmpdir")) + "AggregationPlugin_temp" + File.separator;
            File f = new File(tempDir);
            if (f.exists()) {
                TempDir.deleteDirectory(f);
            }
            instance = new TempDir(tempDir);
        }
        return instance;
    }

    public String getPath() {
        if (DataEngineThreadLocal.getInstance().getPathManager() != null) {
            return DataEngineThreadLocal.getInstance().getPathManager().getTempFileName("AggregationPlugin_temp", 0, null);
        }
        return this.path;
    }

    public static void release() {
        if (instance != null) {
            File f = new File(instance.getPath());
            if (f.exists()) {
                TempDir.deleteDirectory(f);
            }
            instance = null;
        }
    }

    private static void deleteDirectory(File dir) {
        File[] subFiles = dir.listFiles();
        if (subFiles != null) {
            int i = 0;
            while (i < subFiles.length) {
                if (subFiles[i].isDirectory()) {
                    TempDir.deleteDirectory(subFiles[i]);
                } else {
                    TempDir.safeDelete(subFiles[i]);
                }
                ++i;
            }
        }
        TempDir.safeDelete(dir);
    }

    private static void safeDelete(File file) {
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }
}

