/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionFactory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IConnectionProfileProvider;
import org.eclipse.datatools.connectivity.IOfflineConnection;
import org.eclipse.datatools.connectivity.IOfflineConnectionFactory;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;
import org.eclipse.datatools.connectivity.internal.InternalConnectionFactoryProvider;

public class ConnectionFactoryProvider
implements InternalConnectionFactoryProvider {
    public static final String ATTR_ID = "id";
    public static final String ATTR_PROFILE = "profile";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_PRIORITY = "priority";
    private String mId;
    private String mName;
    private String mPriority;
    private String mProfile;
    private String mClassAttr;
    private IConnectionFactory mFactory;
    private IConfigurationElement mElement;

    public ConnectionFactoryProvider(IConfigurationElement element) {
        this.init(element);
    }

    public ConnectionFactoryProvider(IConfigurationElement element, String factoryID, String profileID, String classAttr, String priority) {
        this.mElement = element;
        this.mId = factoryID;
        this.mProfile = profileID;
        this.mClassAttr = classAttr;
        this.mPriority = priority;
    }

    public IConnection createConnection(IConnectionProfile profile) {
        this.initFactory();
        if (this.supportsWorkOfflineMode()) {
            return this.createConnection(profile, (IProgressMonitor)new NullProgressMonitor());
        }
        if (this.mFactory != null) {
            return this.mFactory.createConnection(profile);
        }
        return null;
    }

    public IConnection createConnection(IConnectionProfile profile, String uid, String pwd) {
        this.initFactory();
        if (this.mFactory != null) {
            if (uid != null) {
                return this.mFactory.createConnection(profile, uid, pwd);
            }
            return this.createConnection(profile);
        }
        return null;
    }

    public IConnectionProfileProvider getConnectionProfileProvider() {
        return ConnectionProfileManager.getInstance().getProvider(this.mProfile);
    }

    public String getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public String getPriority() {
        return this.mPriority;
    }

    private void init(IConfigurationElement element) {
        Assert.isTrue((boolean)"connectionFactory".equals(element.getName()));
        this.mElement = element;
        this.mId = element.getAttribute(ATTR_ID);
        this.mName = element.getAttribute(ATTR_NAME);
        this.mProfile = element.getAttribute(ATTR_PROFILE);
        this.mClassAttr = ATTR_CLASS;
        this.mPriority = element.getAttribute(ATTR_PRIORITY);
    }

    public Class getConnectionFactoryClass() {
        this.initFactory();
        return this.mFactory.getClass();
    }

    public boolean supportsWorkOfflineMode() {
        this.initFactory();
        return this.mFactory != null && this.mFactory instanceof IOfflineConnectionFactory;
    }

    public boolean canWorkOffline(IConnectionProfile profile) {
        return this.supportsWorkOfflineMode() && ((IOfflineConnectionFactory)this.mFactory).canWorkOffline(profile);
    }

    public IOfflineConnection createConnection(IConnectionProfile profile, IProgressMonitor monitor) {
        if (this.supportsWorkOfflineMode()) {
            return ((IOfflineConnectionFactory)this.mFactory).createConnection(profile, monitor);
        }
        return null;
    }

    public IOfflineConnection createOfflineConnection(IConnectionProfile profile, IProgressMonitor monitor) {
        if (this.supportsWorkOfflineMode()) {
            return ((IOfflineConnectionFactory)this.mFactory).createOfflineConnection(profile, monitor);
        }
        return null;
    }

    private void initFactory() {
        if (this.mFactory != null) {
            return;
        }
        final IConnectionFactory[] result = new IConnectionFactory[1];
        ISafeRunnable code = new ISafeRunnable(){

            public void run() throws Exception {
                result[0] = (IConnectionFactory)ConnectionFactoryProvider.this.mElement.createExecutableExtension(ConnectionFactoryProvider.this.mClassAttr);
            }

            public void handleException(Throwable exception) {
                ConnectivityPlugin.getDefault().log(exception);
            }
        };
        SafeRunner.run((ISafeRunnable)code);
        this.mFactory = result[0];
    }
}

