/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.BandwidthFormatter;
import com.nvidia.viper.ByteSizeFormatter;
import com.nvidia.viper.ViperColors;
import com.nvidia.viper.activity.CuptiActivityNvLink;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.ui.analysis.NodeFigure;
import com.nvidia.viper.ui.analysis.TopologyCanvas;
import org.eclipse.draw2d.ArrowLocator;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionEndpointLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.swt.graphics.Color;

public class NVLinkConnection
extends PolylineConnection
implements IModel {
    CuptiActivityNvLink nvlink;
    Color color;
    String transmitBandwidthLabel;
    String receiveBandwidthLabel;
    ConnectionEndpointLocator transmitEndpoint;
    ConnectionEndpointLocator receiveEndpoint;
    boolean isDirectLink;

    public NVLinkConnection(CuptiActivityNvLink link, boolean isDirectLink) {
        this.nvlink = link;
        this.isDirectLink = isDirectLink;
    }

    public void create() {
        this.setForegroundColor(this.color);
        this.setLineWidth(2);
        PolygonDecoration dec1 = new PolygonDecoration();
        PolygonDecoration dec2 = new PolygonDecoration();
        dec1.setLineWidth(2);
        dec2.setLineWidth(2);
        this.add((IFigure)dec1, new ArrowLocator((Connection)this, 2));
        this.add((IFigure)dec2, new ArrowLocator((Connection)this, 3));
        this.transmitEndpoint = new ConnectionEndpointLocator((Connection)this, true);
        Label tBandwidth = new Label(this.transmitBandwidthLabel);
        tBandwidth.setForegroundColor(ViperColors.COLOR_NVLINK_BANDWIDTH);
        tBandwidth.setFont(TopologyCanvas.LABEL_FONT);
        this.add((IFigure)tBandwidth, this.transmitEndpoint);
        this.receiveEndpoint = new ConnectionEndpointLocator((Connection)this, false);
        Label sourceBandwidth = new Label(this.receiveBandwidthLabel);
        sourceBandwidth.setForegroundColor(ViperColors.COLOR_NVLINK_BANDWIDTH);
        sourceBandwidth.setFont(TopologyCanvas.LABEL_FONT);
        this.add((IFigure)sourceBandwidth, this.receiveEndpoint);
    }

    public CuptiActivityNvLink getActivity() {
        return this.nvlink;
    }

    public long getBandwidth() {
        return this.nvlink.bandwidth * 1000L;
    }

    public NodeFigure getDevice1() {
        return (NodeFigure)this.getSourceAnchor().getOwner();
    }

    public NodeFigure getDevice2() {
        return (NodeFigure)this.getTargetAnchor().getOwner();
    }

    public void setDevice1(ChopboxAnchor anchor) {
        this.setSourceAnchor((ConnectionAnchor)anchor);
    }

    public void setDevice2(ChopboxAnchor anchor) {
        this.setTargetAnchor((ConnectionAnchor)anchor);
    }

    public void setColor(long avgThroughput) {
        long percentageNotUtilized = 100L - 100L * avgThroughput / this.getBandwidth();
        ViperColors.HeatMap[] heatMapArray = ViperColors.HeatMap.values();
        int n = heatMapArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViperColors.HeatMap map = heatMapArray[n2];
            if ((long)map.getPercentValue() >= percentageNotUtilized) {
                this.color = map.getColor();
                return;
            }
            ++n2;
        }
    }

    public void setTransmitBandwidthLabelOffset(int u, int v) {
        this.transmitEndpoint.setUDistance(u);
        this.transmitEndpoint.setVDistance(v);
    }

    public void setReceiveBandwidthLabelOffset(int u, int v) {
        this.receiveEndpoint.setUDistance(u);
        this.receiveEndpoint.setVDistance(v);
    }

    public void setTransmitBandwidthLabel(long bandwidth) {
        if (bandwidth != -1L) {
            this.transmitBandwidthLabel = new BandwidthFormatter(ByteSizeFormatter.Base.KILOBYTE).format(bandwidth, true, 2);
        }
    }

    public void setReceiveBandwidthLabel(long bandwidth) {
        if (bandwidth != -1L) {
            this.receiveBandwidthLabel = new BandwidthFormatter(ByteSizeFormatter.Base.KILOBYTE).format(bandwidth, true, 2);
        }
    }

    public boolean isPeerAccess() {
        return this.nvlink.isPeerAccess();
    }

    public boolean isSystemAccess() {
        return this.nvlink.isSystemAccess();
    }

    public boolean isPeerAtomic() {
        return this.nvlink.isPeerAtomic();
    }

    public boolean isSystemAtomic() {
        return this.nvlink.isSystemAtomic();
    }

    public int getPhysicalLinks() {
        return this.nvlink.physicalNvLinkCount;
    }

    public boolean isDirectLink() {
        return this.isDirectLink;
    }
}

