/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.viper.Activator;
import com.nvidia.viper.StringUtils;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.fs.FileSystem;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UIUtils {
    public static void boldFont(Control control) {
        FontData[] fontData = control.getFont().getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setStyle(fontData[i].getStyle() | 1);
            ++i;
        }
        final Font newFont = new Font(null, fontData);
        control.setFont(newFont);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                newFont.dispose();
            }
        });
    }

    public static void italicFont(Control control) {
        FontData[] fontData = control.getFont().getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setStyle(fontData[i].getStyle() | 2);
            ++i;
        }
        final Font newFont = new Font(null, fontData);
        control.setFont(newFont);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                newFont.dispose();
            }
        });
    }

    public static void setForeground(Composite composite, Color color) {
        if (composite.isDisposed()) {
            return;
        }
        composite.setForeground(color);
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Composite) {
                UIUtils.setForeground((Composite)child, color);
            } else {
                child.setForeground(color);
            }
            ++n2;
        }
    }

    public static void setBackground(Composite composite, Color color) {
        if (composite.isDisposed()) {
            return;
        }
        composite.setBackground(color);
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Composite) {
                UIUtils.setBackground((Composite)child, color);
            } else {
                child.setBackground(color);
            }
            ++n2;
        }
    }

    public static void setEnabled(Composite composite, boolean enabled) {
        composite.setEnabled(enabled);
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Composite) {
                UIUtils.setEnabled((Composite)child, enabled);
            } else {
                child.setEnabled(enabled);
            }
            ++n2;
        }
    }

    public static void browseForFile(Text fileText, String defaultText, Button browseButton, final FileSystem fileSystem, IRunnableContext runnableContext) {
        try {
            Shell shell = browseButton.getShell();
            Path path = new Path(defaultText);
            String prefPath = null;
            prefPath = path.toFile().exists() ? (path.toFile().isDirectory() ? path.toOSString() : path.removeLastSegments(1).toOSString()) : Activator.getDefault().getPreferenceStore().getString("ExecutablePath");
            String[] filename = new String[1];
            runnableContext.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        fileSystem.connect(monitor);
                    }
                    catch (CoreException e) {
                        if (e.getCause() instanceof OperationCanceledException) {
                            CoreUtil.throwInterruptedException((Throwable)e.getCause());
                        }
                        throw new InvocationTargetException(e);
                    }
                }
            });
            filename[0] = fileSystem.browseForFile(shell, "Select a file", "Select application executable file", prefPath);
            if (filename[0] != null) {
                path = new Path(filename[0]);
                prefPath = path.toFile().isDirectory() ? filename[0] : path.removeLastSegments(1).toOSString();
                Activator.getDefault().getPreferenceStore().setValue("ExecutablePath", prefPath);
                fileText.setText(filename[0]);
            }
        }
        catch (InvocationTargetException e) {
            ViperExceptionHandler.handle("Browse for File", "Unable to open file browser", (Exception)e.getCause());
        }
        catch (InterruptedException e) {
            if (!(e.getCause() instanceof OperationCanceledException)) {
                ViperExceptionHandler.handle("Browse for File", "Unable to open file browser", e);
            }
        }
        catch (CoreException e) {
            ViperExceptionHandler.handle("Browse for File", "Unable to open file browser", (Exception)((Object)e));
        }
    }

    public static void browseForDir(Text fileText, String defaultText, Button browseButton, final FileSystem fileSystem, IRunnableContext runnableContext) {
        String filterPath;
        String cwd = defaultText;
        Path dirPath = new Path(cwd);
        if (dirPath.toFile().isDirectory()) {
            filterPath = cwd;
        } else {
            filterPath = Activator.getDefault().getPreferenceStore().getString("WorkingDirPath");
            if (StringUtils.emptyToNull(filterPath) == null) {
                dirPath = new Path(defaultText);
                filterPath = dirPath.removeLastSegments(1).toString();
            }
        }
        try {
            Shell shell = browseButton.getShell();
            runnableContext.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        fileSystem.connect(monitor);
                    }
                    catch (CoreException e) {
                        if (e.getCause() instanceof OperationCanceledException) {
                            CoreUtil.throwInterruptedException((Throwable)e.getCause());
                        }
                        throw new InvocationTargetException(e);
                    }
                }
            });
            String filename = fileSystem.browseForDirectory(shell, "Select a directory", "Select working directory for application", filterPath);
            if (filename != null) {
                Path path = new Path(filename);
                filterPath = path.toFile().isDirectory() ? filename : path.removeLastSegments(1).toOSString();
                Activator.getDefault().getPreferenceStore().setValue("WorkingDirPath", filterPath);
                fileText.setText(filename);
            }
        }
        catch (InvocationTargetException e) {
            ViperExceptionHandler.handle("Browse for Directory", "Unable to open directory browser", (Exception)e.getCause());
        }
        catch (InterruptedException e) {
            if (!(e.getCause() instanceof OperationCanceledException)) {
                ViperExceptionHandler.handle("Browse for Directory", "Unable to open directory browser", e);
            }
        }
        catch (CoreException e) {
            ViperExceptionHandler.handle("Browse for Directory", "Unable to open directory browser", (Exception)((Object)e));
        }
    }
}

