/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.SessionEditorContributedContents;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperHelp;
import com.nvidia.viper.ViperImages;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.actions.ExpertDataModeAction;
import com.nvidia.viper.actions.NumberSeparatorAction;
import com.nvidia.viper.actions.RunProfileAction;
import com.nvidia.viper.editor.SourceSassEditor;
import com.nvidia.viper.expert.EventTableColumnProvider;
import com.nvidia.viper.expert.EventTableContentProvider;
import com.nvidia.viper.fs.LocalFileSystem;
import com.nvidia.viper.model.ExpertData;
import com.nvidia.viper.model.ILoadingListener;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.model.TimelineKernel;
import com.nvidia.viper.model.TimelineKind;
import com.nvidia.viper.ui.ContextManager;
import com.nvidia.viper.ui.IContextOwner;
import com.nvidia.viper.ui.ITitleImageLoadingDelegatee;
import com.nvidia.viper.ui.SessionEditor;
import com.nvidia.viper.ui.TitleImageLoadingDelegator;
import com.nvidia.viper.ui.ViperTableViewer;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.ViewPart;

public class ExpertView
extends ViewPart
implements ISessionPropertyChangeListener,
IContextOwner,
ITitleImageLoadingDelegatee,
ILoadingListener {
    private String originalTitle = "Details";
    private Session activeSession;
    private boolean linkToTimeline = false;
    private TableViewer tableViewer;
    private EventTableColumnProvider columnProvider;
    private RunProfileAction metricsEventsAction;
    private ExpertDataModeAction dataModeAction;
    private NumberSeparatorAction nsaAction;
    private ExportCsvAction exportCsvAction;
    private Action showFilteredTimelineDataAction;
    private Action showHiddenTimelineDataAction;
    private Action filterBySelectionAction;
    private String KEY_SHOW_FILTERED = "expert.showFilteredTimelineData";
    private String KEY_SHOW_HIDDEN = "expert.showHiddenTimelineData";
    private String KEY_FILTER_BY_SELECTION = "expert.filteredBySelection";
    private ActivePartListener asListener = new ActivePartListener();
    private IMemento expertMemento;
    private TitleImageLoadingDelegator titleImageLoadingDelegator;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.originalTitle = site.getPart().getTitle();
        super.init(site, memento);
        this.expertMemento = memento;
        this.titleImageLoadingDelegator = new TitleImageLoadingDelegator(this);
    }

    public void createPartControl(Composite parent) {
        ScrolledComposite sselComp = new ScrolledComposite(parent, 768);
        sselComp.setExpandHorizontal(true);
        sselComp.setExpandVertical(true);
        Composite selComp = new Composite((Composite)sselComp, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        selComp.setLayout((Layout)gl);
        sselComp.setContent((Control)selComp);
        this.tableViewer = new ViperTableViewer(selComp, 0x10010800);
        this.tableViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.tableViewer.setContentProvider((IContentProvider)new EventTableContentProvider());
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getControl().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ExpertView.this.activeSession != null) {
                    ExpertView.this.activeSession.getExpertData().paintView();
                }
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = event.getSelection();
                if (sel instanceof IStructuredSelection) {
                    Object el = ((IStructuredSelection)sel).getFirstElement();
                    if (el instanceof ITimelineInterval) {
                        ExpertView.this.handleIntervalSelection((ITimelineInterval)el);
                    } else if (el instanceof ExpertData.KernelAggregate) {
                        ExpertView.this.handleKernelAggregateSelection((ExpertData.KernelAggregate)el);
                    }
                }
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer, (int)2);
        sselComp.setMinSize(selComp.computeSize(-1, -1));
        this.columnProvider = new EventTableColumnProvider(this.tableViewer);
        this.columnProvider.setShowNumberSeparators(false);
        this.createActions();
        this.createToolbar();
        this.createMenuBar();
        this.refreshActions();
        this.handleNewActivePart((IWorkbenchPart)ContextManager.getSingleton().getActiveSessionEditor());
        ViperHelp.setContextHelp((Control)parent, ViperHelp.EXPERT_VIEW_CONTEXT_ID);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putBoolean(this.KEY_SHOW_FILTERED, this.showFilteredTimelineDataAction.isChecked());
        memento.putBoolean(this.KEY_SHOW_HIDDEN, this.showHiddenTimelineDataAction.isChecked());
        memento.putBoolean(this.KEY_FILTER_BY_SELECTION, this.filterBySelectionAction.isChecked());
    }

    private void createMenuBar() {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.add((IAction)this.filterBySelectionAction);
        menuManager.add((IAction)this.showHiddenTimelineDataAction);
        menuManager.add((IAction)this.showFilteredTimelineDataAction);
    }

    protected void createActions() {
        this.metricsEventsAction = new RunProfileAction(null, null, true, true);
        this.dataModeAction = new ExpertDataModeAction(ExpertData.Mode.KERNEL_AGGREGATE);
        this.setPartName(String.valueOf(this.originalTitle) + " (Summary)");
        this.dataModeAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ExpertData expertData;
                if (event.getProperty().equals("expertdata:mode") && ExpertView.this.activeSession != null && (expertData = ExpertView.this.activeSession.getExpertData()) != null) {
                    ExpertData.Mode mode = (ExpertData.Mode)((Object)event.getNewValue());
                    ExpertView.this.setPartName(String.valueOf(ExpertView.this.originalTitle) + (ExpertData.Mode.INTERVAL.equals((Object)mode) ? "" : " (Summary)"));
                    expertData.setMode(mode);
                    if (expertData.isRefreshIntervals() || expertData.isRefreshAggregate()) {
                        ExpertView.this.activeSession.startEventRefresh();
                    } else {
                        ExpertView.this.refreshEventTable();
                    }
                }
            }
        });
        this.nsaAction = new NumberSeparatorAction(false);
        this.nsaAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("nsa:separator")) {
                    ExpertView.this.columnProvider.setShowNumberSeparators((Boolean)event.getNewValue());
                }
            }
        });
        this.exportCsvAction = new ExportCsvAction();
        this.showFilteredTimelineDataAction = new Action(ViperMessages.ShowFilteredTimelineData_Label, 2){};
        this.showFilteredTimelineDataAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("checked") && ExpertView.this.activeSession != null && ExpertView.this.activeSession.getExpertData() != null) {
                    ExpertView.this.activeSession.getExpertData().setShowFilteredTimelineData((Boolean)event.getNewValue());
                    ExpertView.this.activeSession.getExpertData().refreshAll();
                }
            }
        });
        this.showFilteredTimelineDataAction.setChecked(this.expertMemento != null && this.expertMemento.getBoolean(this.KEY_SHOW_FILTERED) != null ? this.expertMemento.getBoolean(this.KEY_SHOW_FILTERED) : false);
        this.showHiddenTimelineDataAction = new Action(ViperMessages.ShowHiddenTimelineData_Label, 2){};
        this.showHiddenTimelineDataAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("checked") && ExpertView.this.activeSession != null && ExpertView.this.activeSession.getExpertData() != null) {
                    ExpertView.this.activeSession.getExpertData().setShowHiddenTimelineData((Boolean)event.getNewValue());
                    ExpertView.this.activeSession.getExpertData().refreshAll();
                }
            }
        });
        this.showHiddenTimelineDataAction.setChecked(this.expertMemento != null && this.expertMemento.getBoolean(this.KEY_SHOW_HIDDEN) != null ? this.expertMemento.getBoolean(this.KEY_SHOW_HIDDEN) : true);
        this.filterBySelectionAction = new Action(ViperMessages.FilterBySelection_Label, 2){};
        this.filterBySelectionAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("checked") && ExpertView.this.activeSession != null && ExpertView.this.activeSession.getExpertData() != null) {
                    ExpertView.this.activeSession.getExpertData().setFilterBySelection((Boolean)event.getNewValue());
                    ExpertView.this.activeSession.getExpertData().refreshAll();
                }
            }
        });
        this.filterBySelectionAction.setChecked(this.expertMemento != null && this.expertMemento.getBoolean(this.KEY_FILTER_BY_SELECTION) != null ? this.expertMemento.getBoolean(this.KEY_FILTER_BY_SELECTION) : true);
    }

    protected void createToolbar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IAction)this.metricsEventsAction);
        mgr.add((IContributionItem)new Separator("expertSetup"));
        mgr.add((IAction)this.dataModeAction);
        mgr.add((IAction)this.nsaAction);
        mgr.add((IAction)this.exportCsvAction);
    }

    protected void refreshActions() {
        this.metricsEventsAction.setActiveSession(this.activeSession);
        this.metricsEventsAction.setEnabled(this.activeSession != null);
        this.dataModeAction.setEnabled(this.activeSession != null);
        this.nsaAction.setEnabled(this.activeSession != null);
        this.exportCsvAction.setEnabled(this.activeSession != null);
        this.showFilteredTimelineDataAction.setEnabled(this.activeSession != null);
        this.showHiddenTimelineDataAction.setEnabled(this.activeSession != null);
        this.filterBySelectionAction.setEnabled(this.activeSession != null);
        if (this.activeSession != null && this.activeSession.getExpertData() != null) {
            this.dataModeAction.setMode(this.activeSession.getExpertData().getMode());
        }
    }

    protected void refreshEventTable() {
        ExpertData eti = this.activeSession != null ? this.activeSession.getExpertData() : null;
        try {
            this.tableViewer.getTable().setRedraw(false);
            this.columnProvider.setInput(eti);
            this.tableViewer.setItemCount(eti == null ? 0 : eti.getDisplayResultCnt());
            this.tableViewer.getTable().setEnabled(eti != null);
            this.tableViewer.setInput((Object)eti);
        }
        finally {
            this.tableViewer.getTable().setRedraw(true);
        }
    }

    protected void handleKernelAggregateSelection(ExpertData.KernelAggregate result) {
        Timeline revealTimeline = null;
        for (Timeline timeline : result.getTimelines()) {
            if (!timeline.isVisible()) continue;
            revealTimeline = timeline;
            break;
        }
        if (revealTimeline != null) {
            TimelineIntervalPair timelineIntervalPair = new TimelineIntervalPair(revealTimeline, null);
            this.activeSession.revealTimelineInterval(timelineIntervalPair);
        }
    }

    protected void handleIntervalSelection(ITimelineInterval selectedInterval) {
        ITimelineInterval interval = this.activeSession.loadInterval(selectedInterval.getID(), true);
        Timeline timeline = interval.getPrimaryTimeline();
        TimelineIntervalPair newSel = new TimelineIntervalPair(timeline, interval);
        this.activeSession.setPrimaryHighlighted(newSel);
        if (timeline != null) {
            Timeline compute = timeline.getAncestor(TimelineKind.KERNELS);
            if (compute != null) {
                TimelineIntervalPair pair = new TimelineIntervalPair(compute, interval);
                this.activeSession.revealTimelineInterval(pair);
            } else {
                this.activeSession.revealTimelineInterval(newSel);
            }
        }
    }

    protected void handleTimelineSelectedInterval(TimelineIntervalPair intervalAndTimeline) {
        ExpertData eti;
        ExpertData expertData = eti = this.activeSession != null ? this.activeSession.getExpertData() : null;
        if (eti != null) {
            Timeline timeline = intervalAndTimeline == null ? null : intervalAndTimeline.getTimeline();
            ITimelineInterval interval = intervalAndTimeline == null ? null : intervalAndTimeline.getInterval(this.activeSession);
            int idx = -1;
            if (ExpertData.Mode.KERNEL_AGGREGATE.equals((Object)eti.getMode()) && timeline instanceof TimelineKernel) {
                idx = eti.getDisplayResultIndex(eti.getKernelAggregate((TimelineKernel)timeline));
            } else if (interval != null) {
                idx = eti.getDisplayResultIndex(interval);
            }
            if (idx >= 0) {
                this.tableViewer.getTable().setSelection(new int[]{idx});
                this.tableViewer.getTable().showSelection();
            } else {
                this.tableViewer.getTable().deselectAll();
            }
        }
    }

    protected void handleNewActivePart(IWorkbenchPart part) {
        if (part instanceof SessionEditor) {
            this.updateActiveSession(((SessionEditor)part).getSession());
        } else if (part instanceof SourceSassEditor) {
            this.updateActiveSession(((SourceSassEditor)part).getSession());
        }
    }

    private void removeLoadingListener() {
        this.stopLoading("session:dataname:metric");
        this.activeSession.removeLoadingListener(this);
    }

    private void updateActiveSession(Session newSession) {
        if (newSession != null && this.activeSession != newSession) {
            if (this.activeSession != null) {
                this.activeSession.removePropertyChangeListener(this);
                this.removeLoadingListener();
            }
            this.activeSession = newSession;
            this.activeSession.addPropertyChangeListener(this);
            this.activeSession.addLoadingListener(this);
            this.refreshActions();
            this.refreshEventTable();
            this.updateExpertData();
        }
    }

    private void updateExpertData() {
        if (this.activeSession != null) {
            boolean needDataRefresh = false;
            if (this.activeSession.getExpertData().isFilterBySelection() != this.filterBySelectionAction.isChecked()) {
                this.activeSession.getExpertData().setFilterBySelection(this.filterBySelectionAction.isChecked());
                needDataRefresh = true;
            }
            if (this.activeSession.getExpertData().isShowFilteredTimelineData() != this.showFilteredTimelineDataAction.isChecked()) {
                this.activeSession.getExpertData().setShowFilteredTimelineData(this.showFilteredTimelineDataAction.isChecked());
                needDataRefresh = true;
            }
            if (this.activeSession.getExpertData().isShowHiddenTimelineData() != this.showHiddenTimelineDataAction.isChecked()) {
                this.activeSession.getExpertData().setShowHiddenTimelineData(this.showHiddenTimelineDataAction.isChecked());
                needDataRefresh = true;
            }
            if (needDataRefresh) {
                this.activeSession.getExpertData().refreshAll();
            }
        }
    }

    protected void handleClosedPart(IWorkbenchPart part) {
        if (part instanceof SessionEditor && this.activeSession == ((SessionEditor)part).getSession()) {
            this.activeSession.removePropertyChangeListener(this);
            this.removeLoadingListener();
            this.activeSession = null;
            this.refreshActions();
            this.refreshEventTable();
        }
    }

    @Override
    public void ownerChanged(IContextOwner oldOwner, IContextOwner newOwner) {
        this.linkToTimeline = this == newOwner;
    }

    @Override
    public void propertyChange(IModel model, String propertyName) {
        if ("session:expertdata".equals(propertyName)) {
            this.refreshActions();
            this.refreshEventTable();
        } else if (this.linkToTimeline && "session:sInterval".equals(propertyName)) {
            this.handleTimelineSelectedInterval(((Session)model).getPrimarySelected());
        }
    }

    public void setFocus() {
        if (this.tableViewer != null) {
            this.tableViewer.getTable().setFocus();
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener)this.asListener);
        ContextManager.getSingleton().addPossibleOwner(this);
    }

    public void dispose() {
        super.dispose();
        if (this.activeSession != null) {
            this.activeSession.removePropertyChangeListener(this);
            this.removeLoadingListener();
            this.activeSession = null;
        }
        this.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener)this.asListener);
        ContextManager.getSingleton().removePossibleOwner(this);
    }

    public Object getAdapter(Class adapter) {
        if (IContributedContentsView.class.equals((Object)adapter)) {
            return new SessionEditorContributedContents();
        }
        return super.getAdapter(adapter);
    }

    @Override
    public void startLoading(String dataName) {
        if ("session:dataname:metric".equals(dataName)) {
            this.titleImageLoadingDelegator.startLoading(this);
        }
    }

    @Override
    public void stopLoading(String dataName) {
        if ("session:dataname:metric".equals(dataName)) {
            this.titleImageLoadingDelegator.stopLoading(this);
        }
    }

    @Override
    public void delegateSetTitleImage(Image image) {
        this.setTitleImage(image);
    }

    @Override
    public Image delegateGetTitleImage() {
        return this.getTitleImage();
    }

    private class ActivePartListener
    implements IPartListener {
        private ActivePartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            ExpertView.this.handleNewActivePart(part);
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            ExpertView.this.handleNewActivePart(part);
        }

        public void partOpened(IWorkbenchPart part) {
            ExpertView.this.handleNewActivePart(part);
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            ExpertView.this.handleClosedPart(part);
        }
    }

    private class ExportCsvAction
    extends Action {
        public ExportCsvAction() {
            super(ViperMessages.DetailsCsvExport_Label, ViperImages.DESC_DETAILS_CSVEXPORT);
            this.setToolTipText(ViperMessages.DetailsCsvExport_Tooltip);
            this.setId("com.nvidia.viper.detailscsvexport");
        }

        public void run() {
            String filename;
            if (ExpertView.this.columnProvider != null && (filename = LocalFileSystem.browseForFileSave(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Export Details", null, "SaveDialogPath")) != null) {
                try {
                    FileOutputStream os = new FileOutputStream(filename);
                    BufferedOutputStream bos = new BufferedOutputStream(os);
                    ExpertView.this.columnProvider.getCsv(bos);
                    bos.close();
                }
                catch (Exception e) {
                    ViperExceptionHandler.handle(ViperMessages.ExportDetailsCsv_Fail_Title, ViperMessages.ExportDetailsCsv_Fail_Message, e);
                }
            }
        }
    }
}

