/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.cuda.ide.util.ISourceMarker;
import com.nvidia.viper.Activator;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.activity.CuptiActivitySourceLocator;
import com.nvidia.viper.analysis.AnalysisSourceMarker;
import com.nvidia.viper.model.IMarkerRequester;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.Session;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gef.Disposable;

public class SourceLocator
implements Disposable {
    private Session session;
    private Map<Integer, CuptiActivitySourceLocator> locationIdMap;
    private Map<FileNameLine, CuptiActivitySourceLocator> locationMap;
    private Map<IMarkerRequester, AnalysisMarkerData> analysisMarkerMap;
    private int nextId;

    public SourceLocator(Session session) {
        this.session = session;
        this.locationIdMap = new HashMap<Integer, CuptiActivitySourceLocator>();
        this.locationMap = new HashMap<FileNameLine, CuptiActivitySourceLocator>();
        this.analysisMarkerMap = new HashMap<IMarkerRequester, AnalysisMarkerData>();
        this.nextId = 0;
    }

    public void dispose() {
        this.session = null;
        this.analysisMarkerMap.clear();
        this.analysisMarkerMap = null;
    }

    private int getUniqueId() {
        int uniqueId = this.nextId;
        while (uniqueId < Integer.MAX_VALUE) {
            if (uniqueId != 0 && !this.locationIdMap.containsKey(uniqueId)) break;
            ++uniqueId;
        }
        ++this.nextId;
        return uniqueId;
    }

    public Collection<CuptiActivitySourceLocator> getLocations() {
        return Collections.unmodifiableCollection(this.locationIdMap.values());
    }

    public CuptiActivitySourceLocator getLocation(int id) {
        return this.locationIdMap.get(id);
    }

    public CuptiActivitySourceLocator getLocation(CuptiActivitySourceLocator cuptiLocator, int lineNumber) {
        return this.locationMap.get(new FileNameLine(cuptiLocator.getFileUri(), lineNumber));
    }

    public CuptiActivitySourceLocator getLocation(URI fileName, int lineNumber) {
        return this.locationMap.get(new FileNameLine(fileName, lineNumber));
    }

    private CuptiActivitySourceLocator addLocation(CuptiActivitySourceLocator source) {
        CuptiActivitySourceLocator current = this.locationMap.get(new FileNameLine(source.getFileUri(), source.lineNumber));
        if (current == null) {
            this.locationIdMap.put(source.id, source);
            this.locationMap.put(new FileNameLine(source.getFileUri(), source.lineNumber), source);
            current = source;
        }
        return current;
    }

    public CuptiActivitySourceLocator createLocation(CuptiActivitySourceLocator cuptiLocator, int lineNumber) {
        CuptiActivitySourceLocator loc = new CuptiActivitySourceLocator(this.getUniqueId(), lineNumber, cuptiLocator.fileName);
        return this.addLocation(loc);
    }

    public AnalysisSourceMarker getAnalysisMarker(IMarkerRequester requester, boolean manualResolve) {
        CuptiActivitySourceLocator source;
        if (!this.analysisMarkerMap.containsKey(requester)) {
            return null;
        }
        AnalysisMarkerData data = this.analysisMarkerMap.get(requester);
        AnalysisSourceMarker marker = data.marker;
        if (marker == null && (source = this.getLocation(requester.getSourceLocatorId())) != null) {
            HashMap<Object, URI> resolvedPaths = new HashMap<Object, URI>();
            resolvedPaths.put(source, source.getFileUri());
            Activator.getDefault().getViperWorkbench().resolvePathsInSession(this.session, resolvedPaths);
            URI resolvedPath = (URI)resolvedPaths.get(source);
            if (manualResolve && resolvedPath == null) {
                HashSet<URI> manualPaths = new HashSet<URI>();
                manualPaths.add(source.getFileUri());
                Activator.getDefault().getViperWorkbench().updatePathsInSession(this.session, manualPaths, false);
                resolvedPaths.put(source, source.getFileUri());
                Activator.getDefault().getViperWorkbench().resolvePathsInSession(this.session, resolvedPaths);
                this.refreshAnalysisMarkers();
                resolvedPath = (URI)resolvedPaths.get(source);
            }
            if (resolvedPath != null) {
                marker = new AnalysisSourceMarker(this.session, resolvedPath, source.lineNumber, data.desc);
                try {
                    Activator.getDefault().getSourceIntegration().addMarkers(null, new ISourceMarker[]{marker});
                }
                catch (CoreException e) {
                    ViperExceptionHandler.logError("unable to create analysis result marker", e);
                    marker = null;
                }
            }
            data.marker = marker;
        }
        return marker;
    }

    public void requestAnalysisMarker(IMarkerRequester requester, String desc) {
        if (this.analysisMarkerMap.containsKey(requester)) {
            this.removeAnalysisMarker(requester);
        }
        this.analysisMarkerMap.put(requester, new AnalysisMarkerData(desc));
        this.getAnalysisMarker(requester, false);
    }

    public boolean removeAnalysisMarker(IMarkerRequester requester) {
        if (!this.analysisMarkerMap.containsKey(requester)) {
            return true;
        }
        boolean ret = true;
        try {
            AnalysisMarkerData data = this.analysisMarkerMap.get(requester);
            if (data.marker != null) {
                Activator.getDefault().getSourceIntegration().removeMarkers(null, new ISourceMarker[]{data.marker});
            }
        }
        catch (CoreException e) {
            ViperExceptionHandler.logError("unable to remove marker", e);
            ret = false;
        }
        this.analysisMarkerMap.remove(requester);
        return ret;
    }

    public void refreshAnalysisMarkers() {
        for (IMarkerRequester requester : new HashSet<IMarkerRequester>(this.analysisMarkerMap.keySet())) {
            AnalysisMarkerData data = this.analysisMarkerMap.get(requester);
            this.requestAnalysisMarker(requester, data.desc);
        }
    }

    public void resetForNewTimeline() {
        this.locationIdMap.clear();
        this.locationMap.clear();
        for (IMarkerRequester requester : new HashSet<IMarkerRequester>(this.analysisMarkerMap.keySet())) {
            this.removeAnalysisMarker(requester);
        }
        this.nextId = 0;
    }

    public void appendToPDM(ProfileDataModel pdm) throws ViperException {
        for (CuptiActivitySourceLocator location : this.locationIdMap.values()) {
            try {
                location.appendToPDM(pdm.getNativeHandle());
            }
            catch (Exception e) {
                if (e instanceof ViperException) {
                    throw (ViperException)e;
                }
                throw new ViperException(e);
            }
        }
    }

    private class AnalysisMarkerData {
        private AnalysisSourceMarker marker = null;
        private final String desc;

        private AnalysisMarkerData(String desc) {
            this.desc = desc;
        }
    }

    private class FileNameLine {
        private final URI fileName;
        private final int lineNumber;

        private FileNameLine(URI fileName, int lineNumber) {
            this.fileName = fileName;
            this.lineNumber = lineNumber;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FileNameLine) {
                FileNameLine other = (FileNameLine)obj;
                return this.fileName.equals(other.fileName) && this.lineNumber == other.lineNumber;
            }
            return false;
        }

        public int hashCode() {
            return this.fileName.hashCode() + this.lineNumber;
        }
    }
}

