/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.expert;

import com.nvidia.viper.fs.IDevicesData;
import com.nvidia.viper.model.Event;
import com.nvidia.viper.model.EventCategory;
import java.util.Arrays;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ExpertEventContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private String deviceType;
    private IDevicesData deviceData;

    public ExpertEventContentProvider(IDevicesData deviceData) {
        this.deviceData = deviceData;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof String) {
            this.deviceType = (String)newInput;
        }
    }

    public Object[] getElements(Object inputElement) {
        if (this.deviceType != null) {
            Object[] categories = this.deviceData.getEventCategories(this.deviceType).toArray(new EventCategory[0]);
            Arrays.sort(categories);
            return categories;
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        if (element instanceof EventCategory) {
            return this.deviceType;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof EventCategory;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof EventCategory) {
            Object[] events = ((EventCategory)parentElement).getEvents().toArray(new Event[0]);
            return events;
        }
        return EMPTY_ARRAY;
    }

    public void dispose() {
    }
}

